import * as messages from '../i18n/error-messages';
import { MainInifniException } from '../exceptions/infini-abstract-exception';
import { InifniInternalServerErrorException } from '../exceptions/infini-internalservererror-exception';
import { AppLoggerService } from '../services/logger.service';
import { ERROR_OCCURRED } from '../constants/strings-constants';

export function handleKnownErrors(code:string, error: any): never {
  console.error('Error occured: ', error);
  const logger = AppLoggerService.getInstance();
  logger.error(ERROR_OCCURRED, error);

  if (error instanceof MainInifniException) {
    throw error; // Rethrow custom exceptions
  }

  // Wrap unexpected errors in a generic exception to preserve the stack trace
  throw new InifniInternalServerErrorException(
    code ?? 'INTERNAL_SERVER_ERROR',
    error  
  );
}

/**
 * Fetches and formats an error message based on the error code and provided arguments.
 * @param {string} code - The error code.
 * @param {...string[]} args - The arguments to replace placeholders in the message.
 * @returns {string} - The formatted error message.
 */
export function getErrorMessage(code: string, ...args: string[]): string {
  const template = messages[code];
  if (!template) {
    return 'Unknown error';
  }
  return args.reduce((msg, arg, index) => msg.replace(`{${index}}`, arg), template);
}