import { InvoiceTemplateDto, ProFormaInvoice } from './dtos/templates.dto';

//INVOICE_IGST_TEMPLATE is not in use
export const INVOICE_IGST_TEMPLATE = (data: any): string => `
<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Invoice</title>
</head>

<body style="margin: 0; padding: 0;">
    <div style="max-width: 800px; margin: 0 auto; padding: 20px; border: 1px solid #ccc;">
        <div style="text-align: center; margin-bottom: 20px;">
            <img src="${data.logoUrl}" alt="infiniteheism logo" style="width: 200px;" />
            <div style="text-align: center;">
                <p style="margin: 5px 0;">${data.companyName}</p>
                <p style="margin: 5px 0;">${data.companyAddress}</p>
                <p style="margin: 5px 0;"><a href="${data.companyWebsite}" style="color: #0066cc;">${data.companyWebsite}</a></p>
                <p style="margin: 5px 0;">PAN: ${data.companyPAN} | ${data.companyGST} | CIN: ${data.companyCIN}</p>
            </div>
        </div>
        <hr style="border: 1px solid #ccc; margin: 20px 0;" />
        <h3 style="margin: 5px 0;">Tax Invoice</h3>
        <div style="margin-bottom: 20px;">
            <div style="display: flex; justify-content: space-between;">
                <div>
                    <p style="margin: 5px 0;">Invoice No: ${data.invoiceNumber}</p>
                    <p style="margin: 5px 0;">Date: ${data.invoiceDate}</p>
                </div>
                <div>
                    <p style="margin: 5px 0;">Place of Supply: ${data.placeOfSupply}</p>
                    <p style="margin: 5px 0;">GST is Payable on Reverse charge: ${data.gstReverseCharge}</p>
                </div>
            </div>
        </div>
        <hr style="border: 1px solid #ccc; margin: 20px 0;" />
        <div style="margin-bottom: 20px;">
            <p style="margin: 5px 0;"><strong>Bill To</strong></p>
            <p style="margin: 5px 0;">${data.billToName}</p>
            <p style="margin: 5px 0;">${data.billToAddress}</p>
            <p style="margin: 5px 0;">GSTIN: ${data.billToGSTIN}</p>
        </div>
        <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
            <thead>
                <tr>
                    <th style="border: 1px solid #000; padding: 8px; text-align: left;">Particulars</th>
                    <th style="border: 1px solid #000; padding: 8px; text-align: right;">Amount</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td style="border: 1px solid #000; padding: 8px;">${data.particulars}</td>
                    <td style="border: 1px solid #000; padding: 8px; text-align: right;">₹ ${data.amount}</td>
                </tr>
                <tr>
                    <td style="border: 1px solid #000; padding: 8px;">IGST @ ${data.igstRate}%</td>
                    <td style="border: 1px solid #000; padding: 8px; text-align: right;">₹ ${data.igstAmount}</td>
                </tr>
                <tr>
                    <td style="border: 1px solid #000; padding: 8px;">${data.additionalInfo}</td>
                    <td style="border: 1px solid #000; padding: 8px; text-align: right;"></td>
                </tr>
                <tr>
                    <td style="border: 1px solid #000; padding: 8px; font-weight: bold;">Total</td>
                    <td style="border: 1px solid #000; padding: 8px; text-align: right; font-weight: bold;">₹ ${data.totalAmount}</td>
                </tr>
            </tbody>
        </table>
        <p style="margin-bottom: 20px;">Invoice amount in words: ${data.amountInWords}</p>
        <hr style="border: 1px solid #ccc; margin: 20px 0;" />
        <div style="display: flex; justify-content: space-between; margin-bottom: 20px;">
            <div>
                <img src="${data.qrCodeUrl}" alt="QR Code" style="width: 150px; height: 150px;" />
            </div>
            <div>
                <p style="margin: 5px 0;"><strong>Acknowledgement Date</strong></p>
                <p style="margin: 5px 0;">${data.acknowledgementDate}</p>
                <p style="margin: 5px 0;"><strong>Acknowledgement#</strong></p>
                <p style="margin: 5px 0;">${data.acknowledgementNumber}</p>
                <p style="margin: 5px 0;"><strong>IRN</strong></p>
                <p style="margin: 5px 0;">${data.irn}</p>
            </div>
        </div>
        <hr style="border: 1px solid #ccc; margin: 20px 0;" />
        <p style="margin-top: 20px; text-align:center;">(Note: this is computer generated invoice and hence signature is not required)</p>
    </div>
</body>

</html>`;

//WELCOME_TEMPLATE is not in use
export const WELCOME_TEMPLATE = (data: any): string => `<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Document</title>
    <style>
        .container {
            background-color: rgb(239, 239, 239);
            text-align: center;
            padding: 50px;
        }

        .content {
            background-color: white;
            padding: 30px;
            width: 80%;
            margin: 0 auto;
        }

        .content p {
            width: 100%;
            text-align: left;
        }
    </style>
</head>

<body>
    <div class="container">
        <div>
        <img  style="width:320px; height:100px; padding:20px" src ="https://delta-node-test.s3.ap-south-1.amazonaws.com/Entrainment+Blue.png" alt="Entrainment"/>        </div>
        <div class="content">
            <p>Wishing you Most and more...</p>
             <p>Dear ${data.name}</p>
            <p>
                Please find the enclosed invoice in acknowledgement of your payment
                for 'This <span style="color: orangered">AND</span> That(TAT) Online
                Live - Apr-May 2024'.
            </p>
            <p>
                Let this 'TAT' magnetise the best of everything in your life... Team
                <span style="color: blueviolet">infinithesim</span>
            </p>
            <p>Helpline: +91-9841660000 (Timings: 9:30 a.m. - 6:00 p.m. IST)</p>
            <p>
                Email:
                <span style="text-decoration: underline; color: blue">
                    events@infinitheism.com
                </span>
            </p>
            <hr />
        </div>
        <div>
            <a href="#" style="text-decoration: none; color: black">www.inifinithesim.com</a>
        </div>
    </div>
</body>

</html>`;

//INVOICE_CGST_SGCT_INVOICE is not in use
export const INVOICE_CGST_SGCT_INVOICE = (data: any): string => {
  return `
      <!doctype html>
      <html lang="en">
      <head>
          <meta charset="UTF-8" />
          <meta name="viewport" content="width=device-width, initial-scale=1.0" />
          <title>Invoice</title>
      </head>
      <body style="margin: 0; padding: 0;">
          <div style="max-width: 800px; margin: 0 auto; padding: 20px; border: 1px solid #ccc;">
              <div style="text-align: center; margin-bottom: 20px;">
                  <img src="${data.logoUrl}" alt="Company Logo" style="width: 200px;" />
                  <div style="text-align: center;">
                      <p style="margin: 5px 0;">${data.companyName}</p>
                      <p style="margin: 5px 0;">${data.companyAddress}</p>
                      <p style="margin: 5px 0;"><a href="${data.companyWebsite}" style="color: #0066cc;">${data.companyWebsite}</a></p>
                      <p style="margin: 5px 0;">PAN: ${data.companyPAN} | ${data.companyGST} | CIN: ${data.companyCIN}</p>
                  </div>
              </div>
              <hr style="border: 1px solid #ccc; margin: 20px 0;" />
              <h3 style="margin: 5px 0;">Tax Invoice</h3>
              <div style="margin-bottom: 20px;">
                  <div style="display: flex; justify-content: space-between;">
                      <div>
                          <p style="margin: 5px 0;">Invoice No: ${data.invoiceNumber}</p>
                          <p style="margin: 5px 0;">Date: ${data.invoiceDate}</p>
                      </div>
                      <div>
                          <p style="margin: 5px 0;">Place of Supply: ${data.placeOfSupply}</p>
                          <p style="margin: 5px 0;">GST is Payable on Reverse charge: ${data.gstReverseCharge}</p>
                      </div>
                  </div>
              </div>
              <hr style="border: 1px solid #ccc; margin: 20px 0;" />
              <div style="margin-bottom: 20px;">
                  <p style="margin: 5px 0;"><strong>Bill To</strong></p>
                  <p style="margin: 5px 0;">${data.billToName}</p>
                  <p style="margin: 5px 0;">${data.billToAddress}</p>
                  <p style="margin: 5px 0;">GSTIN: ${data.billToGSTIN}</p>
              </div>
              <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
                  <thead>
                      <tr>
                          <th style="border: 1px solid #000; padding: 8px; text-align: left;">Particulars</th>
                          <th style="border: 1px solid #000; padding: 8px; text-align: right;">Amount</th>
                      </tr>
                  </thead>
                  <tbody>
                      <tr>
                          <td style="border: 1px solid #000; padding: 8px;">${data.particulars}</td>
                          <td style="border: 1px solid #000; padding: 8px; text-align: right;">₹ ${data.amount}</td>
                      </tr>
                      <tr>
                          <td style="border: 1px solid #000; padding: 8px;">CGST @ ${data.cgstRate}%</td>
                          <td style="border: 1px solid #000; padding: 8px; text-align: right;">₹ ${data.cgstAmount}</td>
                      </tr>
                      <tr>
                          <td style="border: 1px solid #000; padding: 8px;">SGST @ ${data.sgstRate}%</td>
                          <td style="border: 1px solid #000; padding: 8px; text-align: right;">₹ ${data.sgstAmount}</td>
                      </tr>
                      <tr>
                          <td style="border: 1px solid #000; padding: 8px;">${data.additionalInfo}</td>
                          <td style="border: 1px solid #000; padding: 8px; text-align: right;"></td>
                      </tr>
                      <tr>
                          <td style="border: 1px solid #000; padding: 8px; font-weight: bold;">Total</td>
                          <td style="border: 1px solid #000; padding: 8px; text-align: right; font-weight: bold;">₹ ${data.totalAmount}</td>
                      </tr>
                  </tbody>
              </table>
              <p style="margin-bottom: 20px;">Invoice amount in words: ${data.amountInWords}</p>
              <hr style="border: 1px solid #ccc; margin: 20px 0;" />
              <div style="display: flex; justify-content: space-between; margin-bottom: 20px;">
                  <div>
                      <img src="${data.qrCodeUrl}" alt="QR Code" style="width: 150px; height: 150px;" />
                  </div>
                  <div>
                      <p style="margin: 5px 0;"><strong>Acknowledgement Date</strong></p>
                      <p style="margin: 5px 0;">${data.acknowledgementDate}</p>
                      <p style="margin: 5px 0;"><strong>Acknowledgement#</strong></p>
                      <p style="margin: 5px 0;">${data.acknowledgementNumber}</p>
                      <p style="margin: 5px 0;"><strong>IRN</strong></p>
                      <p style="margin: 5px 0;">${data.irn}</p>
                  </div>
              </div>
              <hr style="border: 1px solid #ccc; margin: 20px 0;" />
              <p style="margin-top: 20px; text-align:center;">(Note: this is computer generated invoice and hence signature is not required)</p>
          </div>
      </body>
      </html>`;
};

export const TERMS_AND_CONDITIONS = (data: any): string => {
  return `<!DOCTYPE html>
    <html lang="en">
    <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <style>
    *{
    margin: 0px;
    padding: 0px;
    }
    li{
    margin-top: 10px;
    margin-left: 15px;
    font-size: 14px;
    line-height: 20px;
    padding-left: 10px;
    }
    p{
    font-size: 14px;
    }
    span{
    font-size: 14px;
    }
    @page {
    size: A4;
    margin: 7.5mm 20mm;
    }
    </style>
    </head>
    
    <body style="font-family: Arial, sans-serif; display: flex; flex-direction: column; gap:20px; align-items: center;">
    <div style="text-align: center; font-size: 14px; font-weight: 600; margin-top: 20px;">
    <img src="https://delta-node-test.s3.ap-south-1.amazonaws.com/Entrainment+Blue.png" alt="logo" width="230px">
    <p>Leonia Holistic Destination, Hyderabad</p>
    <p style="margin-top: 7px;">Wednesday, 18 September to Saturday, 21 September 2024</p>
    <p style="margin-top: 7px;font-size: 14px; font-weight: 600;">Terms and Conditions</p>
    <div style ="display:flex; justify-content:space-between; align-items:center; width:100%">
    <p style="margin-top: 7px; text-align: left; width:50%;"> Name: ${data.name}</p>
    <p style="margin-top: 7px; text-align: right; width:50%;"> Email: ${data.email}</p>
    </div>
    <p style="margin-top: 7px; font-size: 14px; font-weight: 100; text-align: left; line-height: 20px; ">For the purposes of clarity, the term "we/our/us/infinitheism" refers to 'infinitheism Spiritual Foundation
        Private Limited' and the term "you/your" refers to the participant of the Entrainment 24
        ("program").</p>
    </div>

    <ol style="width: 98%;">
        <p style="font-weight: bold; width: 100%; text-align: left;">A. General:</p>
        <li>The sessions will be conducted in English.</li>
        <li>Registration is on a first-come, first-served basis.</li>
        <li>Registration is confirmed only on receipt of a confirmation email from infinitheism upon
    completion of registration and realisation of full payment and subject to availability of seats.</li>
        <li>Registration is applicable for all participants who have completed 3 years of age, as on 17
            September 2024.</li>
        <li>If you plan to bring your child below 3 years of age, please send an email
            to <a href="mailto:events@infinitheism.com">events@infinitheism.com</a> with details of your child.</li>
        <li>Parental consent is a must for participants who are below 18 years of age. The parental consent
    cum declaration form will be sent to the registered email address and will have to be signed by a
    parent/guardian and submitted to infinitheism on or before Wednesday, 11 September 2024.</li>
        <li><span style="font-weight: 600;">Program Venue: Leonia Holistic Destination,</span> Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, <span style="font-weight: 600;">Hyderabad</span> - 500078.</li>
        <li>The package includes accommodation on a double occupancy basis at Leonia Holistic
    Destination or at any other nearby resort including all meals starting from High Tea on
    Wednesday, 18 September to Lunch on Saturday, 21 September 2024.</li>
        <li>Any other expenses like room service, laundry etc., which are not part of the package, will have
    to be settled by the participant directly to Leonia or the other resort where the participant is
    accommodated.
        </li>
        <li><span style="font-weight: 600;">Airport Pick-up Time:</span> Buses will be available at Hyderabad airport from <span style="font-weight: 600;">3:00 p.m. to 7:00
            p.m.</span> on <span style="font-weight: 600;"> Wednesday, 18 September 2024.</span></li>
        <li> <span style="font-weight: 600;">City Pick-up Time: </span>Buses will depart at <b>5:00 p.m.</b> from Ratnadeep, East Marredpally, Secunderabad
            on <span style="font-weight: 600;">Wednesday, 18 September 2024.</span></li>
        <li><span style="font-weight: 600;">Check-in Time: From 4:00 p.m. to 9:00 p.m. on Wednesday, 18 September 2024, at Leonia.</span></li>
        <li>Travel duration from Hyderabad airport/city to Leonia Holistic Destination is about 90 minutes.
    So kindly plan your travel accordingly.</li>
        <li>Latecomers will not be allowed despite having a valid registration confirmation, immaterial of
    what the reasons may be, including force majeure (Acts of God, acts beyond control, strikes,
    lockouts, bandhs, functions in the family, unexpected circumstances, etc.) and no refund will be
    made at any point in time.</li>
        <li><span style="font-weight: 600;">Check-out Time: Latest by 2:00 p.m. on Saturday, 21 September 2024.</span> We recommend
            outstation participants to plan their return journey departure <span style="font-weight: 600;">post 4:00 p.m.</span> to have enough time to
            reach Hyderabad airport/city.</li>
        <li>Buses will depart from Leonia starting  <span style="font-weight: 600;">11:45 a.m. </span> onwards on <span style="font-weight: 600;">Saturday, 21 September 2024,</span> in
            regular intervals to airport/Ratnadeep, East Marredpally, Secunderabad (City drop).</li>
        <li>Participants who would like to leave the premises earlier than the bus departure timings on the
    check-out date, are requested to make their own arrangements.</li>
    <li>If the registration is done by a person other than a participant (for and on behalf of a
    participant), it shall be the sole responsibility of such person to ensure that the participant
    is/has: (i) made aware of such registration, (ii) given his/her free consent; and (iii) informed
    about the 'terms and conditions'of the program, etc. It is hereby clarified that neither
    infinitheism nor any of its directors, officers, permitted assigns, representatives etc., shall be
    held responsible for any claim made in this regard by any person (including but not limited to
    the participant) at any point in time.</li>
    
        <li>Children (and adults), if found a disturbance, will be asked to leave the program.</li>
        <li>Request for transference of registration from one participant to another, received up to <span style="font-weight: 600;">
    Wednesday, 11 September 2024,</span> will be considered at the sole discretion of the management
    of infinitheism.</li>
    <li>In the event a caretaker is accompanying a participant to the program but will not be attending
    the sessions, then the participant shall ensure that the registration and payment is made for
    such caretaker also.</li>
        <li>Smoking, consumption of alcohol and chewing of tobacco are strictly prohibited within the
    premises.</li>
        <li>While infinitheism will take care that strangers of opposite gender are not accommodated in a
    same room, the overall room allocation to participants will be decided by the management of
    infinitheism at its sole discretion.</li>
        <li>Usage of mobile phones or any other devices causing disturbances will not be allowed during
    the sessions.
        </li>
        <li>Recording the event in any form, audio or video, through mobile or camera is strictly prohibited.</li>
        <li>The management of infinitheism reserves the right to deny entry and registration, without
    assigning any reason. infinitheism will not be responsible for damage or loss of belongings and
    valuables of any participant.</li>
        </ol>
        <p style="font-weight: bold; width: 100%; text-align: left;">B. Cancellation and Refund Policy:</p>
        <ol start="27" style="width: 98%;">
            <li>Cancellation of registration and refund of the fee is governed as below:
                <ol type="a">
                    <li>Participants who want to cancel their registrations for whatever reason, are requested to
                        send an email to <a href="mailto:events@infinitheism.com">events@infinitheism.com</a>, from their registered email address, clearly
                        mentioning their request for cancellation along with their name, mobile number and
                        registration number.</li>
                    <li>Cancellation requests received up to <span style="font-weight: 600;">Wednesday, 11 September 2024,</span> will be eligible
    for a refund of the amount paid. Cancellation requests received after this timeline or
    request for refund citing non-attendance due to late coming and/ or whatever reason or
    leaving the venue before completion of the program (i.e., before the check-out date), are
    not eligible for refund of amount paid, under any circumstance.</li>
        <li>Refunds will not be paid by cash irrespective of the mode of payment by the participant
    at the time of registration.</li>
            </ol>
            </li>
        </ol>
        <li style="width: 100%; text-align: left; list-style-type:none; padding:0px; margin:0px; line-height:20px;"><span style = "font-weight: bold;" >C. Collection and usage of personal information:</span>
    <p style="padding-left:24px;">You consent to the collection and use of your
    personal information that you provide in connection with the Program, by us. We will use your
    information to send details and announcements related to the Program to you. Any personal
    information that you provide to us online will be handled in accordance with the laws and
    regulations of India. We are committed to protecting your personal information and your right
    to privacy. Our 'Privacy Policy' and 'Terms & Conditions' govern the collection, storing, and
    processing of your information provided by you through our website. You agree that we may
    use any information that we obtain about you in accordance with our 'Privacy Policy' and
    'Terms & Conditions’ and applicable laws. Please read our 'Privacy Policy' carefully as it will help
    you make informed decisions about sharing your personal information with us. If the
    participant is below 18 years of age, the parent/guardian of such participant shall be
    responsible for providing consent to the collection and usage of personal data/information of
    the said participant under this Clause.</p></li>
        <div style="width: 98%;">
        <ol start="28">
            <li><span style="font-weight: 600;">Limitation of liability:</span> Infinitheism’s liability for any accepted claim is limited to an aggregate
                maximum of the fee amount paid by the respective participant for all claims whatsoever. However,
                this clause is not applicable for claiming refund due to cancellation or non-attendance, which is
                specifically governed by 'cancellation and refund policy' mentioned above.</li>
            <li><span style="font-weight: 600;">Jurisdiction:</span> The provisions of this 'Terms and Conditions' shall be governed by and construed in
                accordance with the laws of India, and subject to Point 30 below, the parties shall submit to the
                exclusive jurisdiction of the courts at Chennai, India, in relation to any disputes arising under this
                Agreement.</li>
            <li><span style="font-weight: 600;">Disputes:</span> In the event of any dispute, controversy or difference ("<span style="font-weight: 600;">Dispute</span>") of whatever nature,
                arising under, out of, in connection with or relating to any 'terms and conditions' listed herein or otherwise, such
                Dispute shall be settled through good faith, negotiation amongst the parties to such Dispute. In the
                event that such Dispute cannot be resolved by negotiation within thirty (30) days of the Dispute
                having arisen, such Disputes shall be referred to binding arbitration and determined in accordance
                with the provisions of the Arbitration and Conciliation Act, 1996. The venue, place and seat of
                arbitration shall be Chennai, India and shall be conducted in English. The arbitration shall
                be conducted by a sole arbitrator mutually appointed by the parties failing which the arbitrator shall
                be appointed as per the provisions of the Arbitration and Conciliation Act, 1996.</li>
            </ol>
        </div>
        <p><input type="checkbox" checked> I agree to receive information from infinitheism and hereby provide my consent, through any
            medium of communication including but not limited to SMS, WhatsApp, Email and phone calls. I
            have read, understood, provide my consent and agree to the above 'terms and conditions'.</p>
        <hr style="border:1px solid rgb(207, 201, 201) ;width:100%"/>
    </body>
   
    </html>`;
};
export const PARENTAL_TERMS_AND_CONDITIONS = (data: any): string => {
  return `<!DOCTYPE html>
  <html lang="en">
  
  <head>
      <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title>Document</title>
      <style>
          *{
              margin: 0px;
              padding: 0px;
          }
          li{
              margin-top: 10px;
              margin-left: 15px;
              font-size: 14px;
              line-height: 20px; 
              padding-left: 10px;
          }
          p{
              font-size: 14px;
          }
          span{
              font-size: 14px; 
          }
               @page {
            size: A4;
            margin: 7.5mm 20mm;
        }
      </style>
  </head>
  
  <body style="font-family: Arial, sans-serif;  display: flex; flex-direction: column; gap:20px; align-items: center;">
      <div style="text-align: center; font-size: 14px; font-weight: 600; margin-top: 20px;">
          <img src="https://delta-node-test.s3.ap-south-1.amazonaws.com/Entrainment+Blue.png" alt="logo" width="230px">
          <p>Leonia Holistic Destination, Hyderabad</p>
          <p style="margin-top: 7px;">Wednesday, 18 September to Saturday, 21 September 2024</p>
          <p style="margin-top: 7px;font-size: 14px; font-weight: 600;">Terms and Conditions</p>
           <div style ="display:flex; justify-content:space-between; align-items:center; width:100%">
            <p style="margin-top: 7px; text-align: left; width:50%;"> Name: ${data.name}</p>
            <p style="margin-top: 7px; text-align: right; width:50%;"> Email: ${data.email}</p>
        </div>
          <p style="margin-top: 7px; font-size: 14px; font-weight: 100; text-align: left; line-height: 20px; ">For the purposes of clarity, the term “we/our/us/infinitheism” refers to ‘Infinitheism Spiritual Foundation
              Private Limited’ and the term “you/your” refers to the participant of the Entrainment 2024
              (“program”).</p>
      </div>
     
      <ol style="width: 98%;">
          <p style="font-weight: bold; width: 100%; text-align: left;">A. General:</p>
          <li>Registration is on a first-come, first-served basis.</li>
          <li>Registration is confirmed only on receipt of a confirmation email from infinitheism upon realisation
              of full payment.</li>
          <li>Registration is applicable for all participants who have completed 3 years of age, as on 17
              September 2024.</li>
          <li>If you plan to bring your child below 3 years of age, please send an email
              to <a href="mailto:events@infinitheism.com">events@infinitheism.com</a> with details of the child.</li>
          <li>Parental Declaration is a must for participants who are below 18 years of age. The declaration form
              will be sent to the registered email address and will have to be signed by a parent/guardian and
              submitted to infinitheism on or before Wednesday, 11 September 2024.</li>
          <li>The sessions will be conducted in English.</li>
          <li><span style="font-weight: 600;">program Venue:  ${data.venue}</li>
          <li>The package includes accommodation on a double occupancy basis at Leonia Holistic Destination or
              at any other nearby resort including all meals starting from High Tea on Wednesday, 18 September
              to Lunch on Saturday, 21 September 2024.</li>
          <li>Any other expenses like room service, laundry etc., which are not part of the package, will have to be
              settled by the participant directly to Leonia or the other resort where the participant is accommodated.
          </li>
          <li><span style="font-weight: 600;">Airport Pick-up Time:</span> Buses will be available at Hyderabad airport from <span style="font-weight: 600;">3.00 p.m. to 7.00
              p.m.</span> on <span style="font-weight: 600;"> Wednesday, 18 September, 2024.</span></li>
          <li> <span style="font-weight: 600;">City Pick-up Time: </span>Buses will depart at 5.00 p.m. from Ratnadeep, East Maredpally, Secunderabad
              on  <span style="font-weight: 600;">Wednesday, 18 September 2024.</span></li>
          <li><span style="font-weight: 600;">Check-in Time: From 4.00 p.m. to 9.00 p.m. on Wednesday, 18 September 2024, at Leonia.</span></li>
          <li>Travel duration from Hyderabad city/airport to Leonia Holistic Destination is about 90 minutes. So
              kindly plan your travel accordingly.</li>
          <li>Latecomers will not be allowed despite having a valid registration confirmation, immaterial of what
              the reasons may be, including force majeure (Acts of God, acts beyond control, strikes, lockouts,
              bandhs, functions in the family, unexpected circumstances, etc.) and no refund will be made at any
              point in time.</li>
          <li><span style="font-weight: 600;">Check-out Time: Latest by 2.00 p.m. on Saturday, 21 September 2024.</span> We recommend
              outstation participants to plan their return journey departure <span style="font-weight: 600;">post 4.00 p.m.</span> to have enough time to
              reach Hyderabad airport/city.</li>
          <li>Buses will depart from Leonia starting  <span style="font-weight: 600;">11.45 a.m. </span> onwards on Saturday, 21 September 2024, in
              regular intervals to airport/Ratnadeep, East Maredpally, Secunderabad (City drop).</li>
          <li>Participants who would like to leave the premises earlier than the bus departure timings on the
              check-out date, are requested to make their own arrangements.</li>
          <li>Children (and adults), if found a disturbance, will be asked to leave the program.</li>
          <li>Request for transference of registration from one participant to another, received up to Wednesday,
              11 September 2024, will be considered at the sole discretion of the management of infinitheism.</li>
          <li>Smoking, consumption of alcohol and chewing of tobacco are strictly prohibited within the premises.</li>
          <li>While infinitheism will ensure that 2 people of the same gender are housed in a room, the overall
              room allocation to participants will be decided by the management of infinitheism at its sole
              discretion.</li>
          <li>Usage of mobile phones or any other devices causing disturbances will not be allowed during the sessions.
          </li>
          <li>Recording the event in any form, audio or video, through mobile or camera is strictly prohibited.</li>
          <li>The management of infinitheism reserves the right to deny entry and registration, without assigning
              any reason. infinitheism will not be responsible for damage or loss of belongings and valuables of
              any participant.</li>
      </ol>
      <p style="font-weight: bold; width: 100%; text-align: left;">B. Cancellation and Refund Policy:</p>
      <ol start="25" style="width: 98%;">
          <li>Cancellation of registration and refund of the fee is governed as below:
              <ol type="a">
                  <li>Participants who want to cancel their registrations for whatever reason, are requested to
                      send an email to <a href="mailto:events@infinitheism.com">events@infinitheism.com</a>, from their registered email address, clearly
                      mentioning their request for cancellation along with their name, mobile number and
                      registration number.</li>
                  <li>Cancellation requests received up to Wednesday, 11 September 2024, will be eligible for a
                      refund of the amount paid. Cancellation requests received after this timeline or request for
                      refund citing non-attendance due to late coming or whatever reason are not eligible for
                      refund of amount paid, under any circumstance.</li>
                  <li>Refunds will not be paid by cash irrespective of the mode of payment by the participant at
                      the time of registration.</li>
              </ol>
          </li>
      </ol>
      <p style="font-weight: bold; width: 100%; text-align: left;">C. Collection and usage of personal information:</p>
      <p style="line-height: 20px;">You consent to the collection and use of your personal information that you provide in connection with the program, by us. We will use your information to send details and announcements related to the program to you. Any personal information that you provide to us online will be handled in accordance with the laws and regulations of India. We are committed to protecting your personal information and your right to privacy. Our Privacy Policy and Terms & Conditions govern the collection, storing, and processing of your information provided by you through our website. You agree that we may use any information that we obtain about you in accordance with the Privacy Policy and Terms & Conditions and applicable laws. Please read our Privacy Policy carefully as it will help you make informed decisions about sharing your personal information with us. If the participant is below 18 years of age, the parent/guardian of such participant shall be responsible for providing consent to the collection and usage of personal data/information of the said participant under this Clause.</p>
      <div style="width: 98%;">
      <ol start="26">
          <li><span style="font-weight: 600;">Limitation of liability:</span> Infinitheism’s liability for any accepted claim is limited to an aggregate
              maximum of the fee amount paid by the respective participant for all claims whatsoever. However,
              this clause is not applicable for claiming refund due to cancellation or non-attendance, which is
              specifically governed by ‘cancellation and refund policy’ mentioned above.</li>
          <li><span style="font-weight: 600;">Jurisdiction:</span> The provisions of this Terms and Conditions shall be governed by and construed in
              accordance with the laws of India, and subject to Point 28 below, the parties shall submit to the
              exclusive jurisdiction of the courts at Chennai, India, in relation to any disputes arising under this
              Agreement.</li>
          <li><span style="font-weight: 600;">Disputes:</span> In the event of any dispute, controversy or difference (“<span style="font-weight: 600;">Dispute</span>”) of whatever nature,
              arising under, out of, in connection with or relating to any terms and conditions listed herein, such
              dispute shall be settled through good faith, negotiation amongst the parties to such Dispute. In the
              event that such Dispute cannot be resolved by negotiation within thirty (30) days of the Dispute
              having arisen, such Dispute shall be referred to binding arbitration and determined in accordance
              with the provisions of the Arbitration and Conciliation Act, 1996. The venue, place and seat of
              arbitration shall be Chennai, India and shall be conducted in English language. The arbitration shall
              be conducted by a sole arbitrator mutually appointed by the parties failing which the arbitrator shall
              be appointed as per the provisions of the Arbitration and Conciliation Act, 1996.</li>
          </ol>
      </div>
      <p><input type="checkbox"> I agree to receive information from infinitheism and hereby provide my consent, through any
          medium of communication including but not limited to SMS, WhatsApp, Email and phone calls. I
          have read, understood, provide my consent and agree to the above terms and conditions.</p>
      <hr style="border:1px solid rgb(207, 201, 201) ;width:100%"/>
  </body>
  
  </html>`;
};

export const PARENTAL_DECLARATION = (data: any): string => {
  return `<!DOCTYPE html>
    <html>
      <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="initial-scale=1, width=device-width" />
   
        <link
          rel="stylesheet"
          href="https://fonts.googleapis.com/css2?family=Noto Sans:wght@400;600&display=swap"
        />
   
        <style>
          body {
            margin: 0;
          }
        </style>
      </head>
      <body>
        <div
          style="
            width: 100%;
            position: relative;
            background-color: #fff;
            overflow: hidden;
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            justify-content: flex-start;
            padding: 0px 0px 605px;
            box-sizing: border-box;
            letter-spacing: normal;
          "
        >
          <section
            style="
              width: 100%;
              margin: 0 !important;
              position: absolute;
              height: 100%;
              top: 0px;
              right: 0px;
              bottom: 0px;
              left: 0px;
              display: flex;
              flex-direction: column;
              align-items: center;
              gap:120px;
              padding: 80px 40px 40px;
              box-sizing: border-box;
              min-height: 842px;
              max-width: 100%;
              z-index: 1;
              text-align: left;
              font-size: 12px;
              color: #000;
              font-family: 'Noto Sans';
            "
          >
            <img
              style="
                width: 268px;
                height: 58px;
                position: relative;
                object-fit: contain;
              "
              loading="lazy"
              alt=""
              src="https://entrainment-24.s3.amazonaws.com/Images/entrainmentLogo.png"
            />
            <div style = "display: flex; justify-content: center; position: absolute; top: 180px; text-decoration: underline;"><b style="font-weight: 600;font-size: 15px;">Parental Consent/Declaration</b></div>
            <div
              style="
                align-self: stretch;
                display: flex;
                flex-direction: column;
                align-items: flex-start;
                justify-content: flex-start;
                gap: 24px;
              "
            >
              <div
                style="align-self: stretch; position: relative; "
              >
                <span>I,______________________, father/mother/guardian of </span>
                <span style="font-weight: 600">${data.name},</span>
                <span> hereby confirm that;</span>
              </div>
              <div
                style="
                  align-self: stretch;
                  display: flex;
                  flex-direction: column;
                  align-items: flex-start;
                  justify-content: center;
                  gap: 24px;
                "
              >
              <ol type = 'a' style="margin-left: -24px; display: flex;
                  flex-direction: column;
                  align-items: flex-start;
                  justify-content: center;
                  gap: 24px; ">
 
                <div style="position: relative;">
                <li> I have read, understood and agree to the terms and conditions of
    ‘Entrainment 24’ and hereby consent on behalf of my child to
    participate in ‘Entrainment 24’.
              </li>
                </div>
                <div
                  style="align-self: stretch; position: relative;"
                >
                 
                  <li style="margin: 0">
                   I hereby voluntarily and irrevocably allow my child to participate and experience
    ‘Entrainment 24’.
                  </li>
                 
                </div>
                <div
                  style="align-self: stretch; position: relative;"
                >
                 
                  <li style="margin: 0">
                  I undertake on behalf of my child that my child will strictly adhere to the discipline
    expected in ‘Entrainment 24’.
  </li>
                 
                </div>
                </ol>
              </div>
            </div>
            <div
              style="
                align-self: stretch;
                display: flex;
                flex-direction: column;
                align-items: flex-start;
                justify-content: flex-start;
                gap: 80px;
              "
            >
              <div
                style="align-self: stretch; position: relative;"
              >
                Parent’s/Guardian’s Signature:
                <p>________________________________________ ( <span style="display: inline-block; width: 180px;"> </span>)</p>
              </div>
              <div
                style="
                  align-self: stretch;
                  display: flex;
                  flex-direction: column;
                  align-items: flex-start;
                  justify-content: flex-start;
                  gap: 40px;
                "
              >
                <div
                  style="
                    align-self: stretch;
                    display: flex;
                    flex-direction: row;
                    align-items: flex-start;
                    justify-content: space-between;
                    padding: 0px 162px 0px 0px;
                    gap: 20px;
                  "
                >
                  <div
                    style="
                      position: relative;
                      display: inline-block;
                      min-width: 30px;
                    "
                  >
                    Date:
                  </div>
                  <div
                    style="
                      position: relative;
                      display: inline-block;
                      min-width: 33px;
                    "
                  >
                    Place:
                  </div>
                </div>
                <div
                  style="align-self: stretch; position: relative;"
                >
                  <p style="margin: 0">
                    <span>Please sign and email the scanned copy to </span>
                    <span style="color: #1859b4">events@infinitheism.com</span>
                  </p>
                  <p style="margin: 0">
                    Helpline: +91-9841660000 (09.30 a.m. to 06.00 p.m. IST)
                  </p>
                </div>
              </div>
            </div>
          </section>
          <section style="align-self: stretch; height: 237px; position: relative">
            <img
              style="
                position: absolute;
                top: 0px;
                left: -3px;
                width: 100%;
                height: 100%;
                object-fit: cover;
              "
              alt=""
              src="https://entrainment-24.s3.amazonaws.com/Images/parentalConsentBackground.png"
            />
   
            <div
              style="
                position: absolute;
                top: 178px;
                left: 0px;
                background: linear-gradient(180deg, rgba(255, 255, 255, 0), #fff);
                width: 595px;
                height: 59px;
                z-index: 2;
              "
            ></div>
          </section>
        </div>
      </body>
    </html>`;
};

export const INVOICE = (data: InvoiceTemplateDto): string => {
  return `<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap" rel="stylesheet">
    <style>
        @page {
            size: A4;
            margin: 5mm 20mm;
        }

        * {
            font-family: 'Noto Sans', sans-serif;
            margin: 0;
            padding: 0;
        }
    </style>
</head>

<body>
    <div>

        <div
            style="width:100%; display: flex; flex-direction: column; justify-content: space-between; align-items: center; gap:10px; margin-bottom:20px;">
        <div>
            <img src="https://delta-node-test.s3.ap-south-1.amazonaws.com/redDots.png" alt="Logo"
                style="height:10px; width:45px; margin-bottom: 10px;">
        </div>
        <div style="height: 40px; width:300px; text-align: center;">
            <img src="https://delta-node-test.s3.ap-south-1.amazonaws.com/infinithhesimlogo.png" alt="Logo"
            style="height:100%; width:60%">
        </div>
            <p style="color: #0F377F;
                font-family: Noto Sans;
                font-weight: 500;
                text-align: center;
">infinitheism spiritual foundation private limited</p>
            <p style="
            width: 360px;
            text-align: center;
            font-family: Noto Sans;
            font-weight: 400;
            font-size: 14px;
            ">${data.companyAddress}</p>
            <a style="color:#2035F3;  font-size: 18px; font-family: Inter;" href="www.infinitheism.com">www.infinitheism.com</a>
            <p style="font-family: Noto Sans;
            font-size: 14px;
            font-weight: 400;
            text-align: center;
            ">PAN: ${data.companyPAN} | GSTIN ${data.companyGST} | CIN: ${data.companyCIN}</p>
        </div>
        <div style="width:100%; display: flex; justify-content: space-between; align-items: flex-end;padding: 15px 0px;
         border-top: 1px solid #7D7D7D; border-bottom: 1px solid #7D7D7D;">
            <div>
                <p style="font-size: 16px; font-family: Noto Sans;font-weight: 500;color :#000000">Tax Invoice</p>
                <p style="font-size: 14px; font-family: Noto Sans;color :#000000">Invoice No:${data.invoiceNumber}</p>
                <p style="font-size: 14px; font-family: Noto Sans;color :#000000">Date: ${data.currentDate}</p>
            </div>
            <div>
                ${data.placeOfSupply ? `<p style="font-size: 14px; font-family: Noto Sans; color :#000000">Place of Supply: ${data.placeOfSupply}</p>` : ''}
                <p style="font-size: 14px; font-family: Noto Sans; color :#000000">GST is Payable on Reverse charge: No</p>
            </div>
        </div>
        <div style="width:100%; display: flex; justify-content: space-between; align-items: flex-end;padding: 15px 0px;">
            <div>
                <p style="font-size: 16px; font-family: Noto Sans;font-weight: 500;color :#000000">Bill To</p>
                <p style="font-size: 14px; font-family: Noto Sans;color :#000000">${data.seekerName}</p>
                <p style="font-size: 14px; font-family: Noto Sans;color :#000000">${data.seekerAddress}</p>
                ${data.seekerGstin ? `<p style="font-size: 14px; font-family: Noto Sans;color :#000000">GSTIN:${data.seekerGstin}</p>` : ''}
            </div>
        </div>

        <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
            <thead>
                <tr>
                    <th style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px;text-align: left;font-size: 16px;font-weight: 500;">Particulars</th>
                    <th style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px ; text-align: right;font-size: 16px;font-weight: 500;">Amount</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px ;font-size: 14px;">${data.programName} from
                        (${data.reportingTime} to ${data.checkOutTime}) SAC: 999293</td>
                    <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px ; text-align: right;font-size: 14px;">₹ ${data.amount}</td>
                </tr>
                ${
                  data.igstCheck 
                    ? `<tr>
                    <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px;font-size: 14px;">IGST @ ${data.igstPercentage}%</td>
                    <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px ; width:30%; text-align: right;font-size: 14px;">₹ ${data.igst}</td>
                </tr>
                `
                    : ` <tr>
                    <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px;font-size: 14px;">CGST @ ${data.cgstPercentage}%</td>
                    <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px ; width:30%; text-align: right;font-size: 14px;">₹ ${data.cgst}</td>
                </tr>
                <tr>
                    <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px;font-size: 14px;">SGST @ ${data.sgstPercentage}%</td>
                    <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px; width:30%; text-align: right;font-size: 14px;">₹ ${data.sgst}</td>
                </tr>
                `
                }
        <tr>
        <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px;font-size: 14px;"> Amount includes accommodation and food </td>
        <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px ; width:30%; text-align: right;font-size: 14px;"></td>
    </tr>
                 <tr>
                    <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; text-align: left; font-weight: 500; height:35px;font-size: 16px;">Total</td>
                    <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; text-align: right; font-weight: 500;width:30%; height:35px;font-size: 16px;">₹ ${data.totalAmount}</td>
                </tr>
            </tbody>
        </table>
        <div style="margin-top: 10px;">
            <p style="font-family: Noto Sans;margin: 5px 0;font-size: 14px;">Invoice amount in words: ${data.amountInWords} only</p>
        </div>
        ${
          data.qr
            ? `<div style="margin-top: 20px; display: flex; justify-content: space-between;">
                <div style="height:240px; width:240px">
                    <img src=${data.qr} alt="QR" style="height: 100%; width: 100%;">
                </div>
                <div style="height:240px; width:calc(100% - 245px)">
                    <p style="font-family: Noto Sans;font-size: 14px; display: flex; align-items: center; padding-left: 20px; height:40px; background-color: #F5F5F5;">Acknowledgement Date</p>
                    <p style="font-family: Noto Sans;font-size: 14px; display: flex; align-items: center; padding-left: 20px; height:40px; background-color:#ffffff;">${data.irpDate}</p>
                    <p style="font-family: Noto Sans;font-size: 14px; display: flex; align-items: center; padding-left: 20px; height:40px; background-color: #F5F5F5;">Acknowledgement#</p>
                    <p style="font-family: Noto Sans;font-size: 14px; display: flex; align-items: center; padding-left: 20px; height:40px; background-color:#ffffff;">${data.acknowledgeNumber}</p>
                    <p style="font-family: Noto Sans;font-size: 14px; display: flex; align-items: center; padding-left: 20px; height:40px; background-color: #F5F5F5;">IRN</p>
                    <p style="font-family: Noto Sans;font-size: 14px; display: flex; align-items: center; padding-left: 20px; height:40px; background-color:#ffffff;">${data.irn}</p>
                </div>
            </div>`
            : ''
        }
        <hr style="border: 1px solid #7D7D7D; margin: 20px 0;" />
        <p style="font-family: Noto Sans;margin-top: 20px;font-size: 14px;text-align:center;">(Note: this is computer generated invoice and hence signature is not required)</p>
    </div>
</body>

</html>`;
};

// This code generates a pro forma invoice in HTML format.
export const PRO_FORMA_INVOICE = (data: ProFormaInvoice): string => {
  return `<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>800941a1-19ce-4a6f-9df1-2fc6d1339f28</title>
    <style type="text/css">
      * {
        margin: 0;
        padding: 0;
        text-indent: 0;
      }
      .s1 {
        color: #1c4f8e;
        font-family: 'Noto Sans', sans-serif;
        font-style: normal;
        font-weight: bold;
        text-decoration: none;
        font-size: 15.5pt;
      }
      .s2 {
        color: black;
        font-family: 'Noto Sans', sans-serif;
        font-style: normal;
        font-weight: normal;
        text-decoration: none;
        font-size: 9pt;
      }
      .s3 {
        color: #4ea6cd;
        font-family: 'Noto Sans', sans-serif;
        font-style: normal;
        font-weight: bold;
        text-decoration: underline;
        font-size: 9pt;
      }
      .s4 {
        color: black;
        font-family: 'Noto Sans', sans-serif;
        font-style: normal;
        font-weight: bold;
        text-decoration: none;
        font-size: 9pt;
      }
      .s5 {
        color: black;
        font-family: 'Noto Sans', sans-serif;
        font-style: italic;
        font-weight: bold;
        text-decoration: none;
        font-size: 10.5pt;
      }
      .s6 {
        color: black;
        font-family: 'Noto Sans', sans-serif;
        font-style: normal;
        font-weight: normal;
        text-decoration: none;
        font-size: 11pt;
      }
      .s7 {
        color: black;
        font-family: 'Noto Sans', sans-serif;
        font-style: normal;
        font-weight: normal;
        text-decoration: none;
        font-size: 10.5pt;
      }
      .s8 {
        color: black;
        font-family: 'Noto Sans', sans-serif;
        font-style: normal;
        font-weight: bold;
        text-decoration: none;
        font-size: 9pt;
      }
      .s9 {
        color: black;
        font-family:'Noto Sans', sans-serif;
        font-style: normal;
        font-weight: normal;
        text-decoration: none;
        font-size: 9pt;
      }
      .s10 {
        color: black;
        font-family: 'Noto Sans', sans-serif;
        font-style: normal;
        font-weight: normal;
        text-decoration: none;
        font-size: 9.5pt;
      }
      p {
        color: black;
        font-family: 'Noto Sans', sans-serif;
        font-style: normal;
        font-weight: normal;
        text-decoration: none;
        font-size: 9pt;
        margin: 0pt;
      }
      table,
      tbody {
        vertical-align: top;
        overflow: visible;
      }
    </style>
  </head>
  <body>
    <div style="display: flex; align-items: center; justify-content: center; flex-direction: column;">
      <p style="text-indent: 0pt; text-align: left"><br /></p>
      <table
        style="border-collapse: collapse; margin-left: 3pt"
        cellspacing="0"
      >
        <tr style="height: 75pt">
          <td
            style="
              width: 563pt;
              border-top-style: solid;
              border-top-width: 1pt;
              border-top-color: #333333;
              border-left-style: solid;
              border-left-width: 1pt;
              border-left-color: #333333;
              border-bottom-style: solid;
              border-bottom-width: 2pt;
              border-bottom-color: #333333;
              border-right-style: solid;
              border-right-width: 1pt;
              border-right-color: #333333;
            "
            colspan="3"
          >
            <p style="text-indent: 0pt; text-align: left"><br /></p>
            <p style="padding-left: 193pt; text-indent: 0pt; text-align: left">
              <span>
                <table border="0" cellspacing="0" cellpadding="0" width="100%">
                  <tr>
                    <td style="text-align: center">
                      <div>
                        <img src="https://delta-node-test.s3.ap-south-1.amazonaws.com/redDots.png" alt="Logo"
                            style="height:10px; width:45px; margin-bottom: 20px;">
                      </div>
                      <div style="text-align: center;">
                        <img src="https://delta-node-test.s3.ap-south-1.amazonaws.com/infinithhesimlogo.png" alt="Logo"
                        style="height: 40px; width:245px;">
                      </div>
                    </td>
                  </tr>
                </table>
              </span>
            </p>
          </td>
        </tr>
        <tr style="height: 91pt">
          <td
            style="
              width: 366pt;
              border-top-style: solid;
              border-top-width: 2pt;
              border-top-color: #333333;
              border-left-style: solid;
              border-left-width: 1pt;
              border-left-color: #333333;
              border-bottom-style: solid;
              border-bottom-width: 2pt;
              border-right-style: solid;
              border-right-width: 1pt;
              border-right-color: #333333;
            "
            rowspan="2"
          >
            <p
              class="s1"
              style="
                padding-top: 8pt;
                padding-left: 2pt;
                text-indent: 0pt;
                text-align: center;
              "
            >
              infinitheism spiritual foundation private limited
            </p>
            <p
              class="s2"
              style="
                padding-top: 4pt;
                padding-left: 46pt;
                padding-right: 45pt;
                text-indent: 0pt;
                text-align: center;
              "
            >
              ${data.companyAddress}
            </p>
            <p style="text-indent: 0pt; text-align: left"><br /></p>
            <p
              style="
                padding-left: 2pt;
                padding-right: 1pt;
                text-indent: 0pt;
                text-align: center;
              "
            >
              <a href="http://www.infinitheism.com/" class="s3"
                >www.infinitheism.com</a
              >
            </p>
            <p style="text-indent: 0pt; text-align: left"><br /></p>
            <p
              class="s2"
              style="
                padding-left: 2pt;
                padding-right: 1pt;
                text-indent: 0pt;
                text-align: center;
              "
            >
              PAN : AACCI7694H | GSTIN : ${data.companyGST} | CIN :
              ${data.companyCIN}
            </p>
          </td>
          <td
            style="
              width: 197pt;
              border-top-style: solid;
              border-top-width: 2pt;
              border-top-color: #333333;
              border-left-style: solid;
              border-left-width: 1pt;
              border-left-color: #333333;
              border-bottom-style: solid;
              border-bottom-width: 2pt;
              border-right-style: solid;
              border-right-width: 1pt;
              border-right-color: #333333;
            "
            colspan="2"
          >
            <p style="padding-top: 11pt; text-indent: 0pt; text-align: left">
              <br />
            </p>
            <p
              class="s4"
              style="padding-left: 47pt; text-indent: 0pt; text-align: left"
            >
              PRO-FORMA INVOICE
            </p>
            <p
              class="s4"
              style="
                padding-top: 7pt;
                padding-left: 6pt;
                text-indent: 0pt;
                line-height: 159%;
                text-align: left;
              "
            >
              Invoice No: ${data.invoiceNumber} <br /> Date: ${data.currentDate}
            </p>
          </td>
        </tr>
        <tr style="height: 35pt">
          <td
            style="
              width: 197pt;
              border-top-style: solid;
              border-top-width: 2pt;
              border-left-style: solid;
              border-left-width: 1pt;
              border-left-color: #333333;
              border-bottom-style: solid;
              border-bottom-width: 2pt;
              border-right-style: solid;
              border-right-width: 1pt;
              border-right-color: #333333;
            "
            colspan="2"
          >
            <p style="text-indent: 0pt; text-align: left"><br /></p>
          </td>
        </tr>
        <tr style="height: 61pt">
          <td
            style="
              width: 563pt;
              border-top-style: solid;
              border-top-width: 2pt;
              border-left-style: solid;
              border-left-width: 1pt;
              border-bottom-style: solid;
              border-bottom-width: 1pt;
              border-bottom-color: #333333;
              border-right-style: solid;
              border-right-width: 1pt;
            "
            colspan="3"
          >
            <p
              class="s5"
              style="
                padding-top: 4pt;
                padding-left: 7pt;
                text-indent: 0pt;
                text-align: left;
              "
            >
              Bill To:
            </p>
            <p
              class="s6"
              style="
                padding-top: 7pt;
                padding-left: 5pt;
                text-indent: 0pt;
                text-align: left;
              "
            >
              ${data.seekerName}
            </p>
            <p
              class="s7"
              style="
                padding-top: 7pt;
                padding-left: 5pt;
                text-indent: 0pt;
                text-align: left;
              "
            >
              ${data.seekerAddress}
            </p>
          </td>
        </tr>
        <tr style="height: 26pt">
          <td
            style="
              width: 366pt;
              border-top-style: solid;
              border-top-width: 1pt;
              border-top-color: #333333;
              border-left-style: solid;
              border-left-width: 2pt;
              border-left-color: #333333;
              border-bottom-style: solid;
              border-bottom-width: 1pt;
              border-bottom-color: #333333;
            "
            bgcolor="#D3D3D3"
          >
            <p
              class="s8"
              style="
                padding-top: 7pt;
                padding-left: 8pt;
                text-indent: 0pt;
                text-align: left;
              "
            >
              Particulars
            </p>
          </td>
          <td
            style="
              width: 83pt;
              border-top-style: solid;
              border-top-width: 1pt;
              border-top-color: #333333;
              border-bottom-style: solid;
              border-bottom-width: 1pt;
              border-bottom-color: #333333;
              border-right-style: solid;
              border-right-width: 1pt;
              border-right-color: #333333;
            "
            bgcolor="#D3D3D3"
          >
            <p style="text-indent: 0pt; text-align: left"><br /></p>
          </td>
          <td
            style="
              width: 114pt;
              border-top-style: solid;
              border-top-width: 1pt;
              border-top-color: #333333;
              border-bottom-style: solid;
              border-bottom-width: 1pt;
              border-bottom-color: #333333;
              border-right-style: solid;
              border-right-width: 2pt;
              border-right-color: #333333;
            "
            bgcolor="#D3D3D3"
          >
            <p
              class="s8"
              style="
                padding-top: 7pt;
                padding-right: 6pt;
                text-indent: 0pt;
                text-align: right;
              "
            >
              Amount
            </p>
          </td>
        </tr>
        <tr style="height: 26pt">
          <td
            style="
              width: 366pt;
              border-top-style: solid;
              border-top-width: 1pt;
              border-top-color: #333333;
              border-left-style: solid;
              border-left-width: 1pt;
              border-left-color: #333333;
            "
          >
            <p
              class="s2"
              style="
                padding-top: 7pt;
                padding-left: 7pt;
                text-indent: 0pt;
                text-align: left;
              "
            >
              Fee for &#39;${data.programName}&#39; program from
              ${data.startDate} to ${data.endDate} SAC: 999293
            </p>
          </td>
          <td
            style="
              width: 83pt;
              border-left-width: 1pt;
              border-right-style: solid;
              border-right-width: 1pt;
              border-right-color: #333333;
            "
          >
            <p style="text-indent: 0pt; text-align: left"><br /></p>
          </td>
          <td
            style="
              width: 114pt;
              border-top-style: solid;
              border-top-width: 1pt;
              border-top-color: #333333;
              border-left-style: solid;
              border-left-width: 1pt;
              border-left-color: #333333;
              border-right-style: solid;
              border-right-width: 1pt;
              border-right-color: #333333;
            "
          >
            <p
              class="s9"
              style="
                padding-top: 7pt;
                padding-right: 6pt;
                text-indent: 0pt;
                text-align: right;
              "
            >
              ₹ <span class="s2">${data.amount}</span>
            </p>
          </td>
        </tr>
        <tr style="height: 26pt">
          <td
            style="
              width: 366pt;
              border-left-style: solid;
              border-left-width: 1pt;
              border-left-color: #333333;
            "
          >
            <p
              class="s2"
              style="
                padding-top: 7pt;
                padding-left: 7pt;
                text-indent: 0pt;
                text-align: left;
              "
            >
              GST @ ${data.gstPercentage}%
            </p>
          </td>
          <td
            style="
              width: 83pt;
              border-left-width: 1pt;
              border-right-style: solid;
              border-right-width: 1pt;
              border-right-color: #333333;
            "
          >
            <p style="text-indent: 0pt; text-align: left"><br /></p>
          </td>
          <td
            style="
              width: 114pt;
              border-left-style: solid;
              border-left-width: 1pt;
              border-left-color: #333333;
              border-right-style: solid;
              border-right-width: 1pt;
              border-right-color: #333333;
            "
          >
            <p
              class="s9"
              style="
                padding-top: 7pt;
                padding-right: 6pt;
                text-indent: 0pt;
                text-align: right;
              "
            >
              ₹ <span class="s2">${data.gstAmount}</span>
            </p>
          </td>
        </tr>
        <tr style="height: 26pt">
          <td
            style="
              width: 366pt;
              border-left-style: solid;
              border-left-width: 1pt;
              border-left-color: #333333;
              border-bottom-style: solid;
              border-bottom-width: 1pt;
              border-bottom-color: #333333;
            "
          >
            <p
              class="s8"
              style="
                padding-top: 7pt;
                padding-left: 7pt;
                text-indent: 0pt;
                text-align: left;
              "
            >
              Fee includes accommodation and food.
            </p>
          </td>
          <td
            style="
              width: 83pt;
              border-left-width: 1pt;
              border-bottom-style: solid;
              border-bottom-width: 1pt;
              border-bottom-color: #333333;
              border-right-style: solid;
              border-right-width: 1pt;
              border-right-color: #333333;
            "
          >
            <p style="text-indent: 0pt; text-align: left"><br /></p>
          </td>
          <td
            style="
              width: 114pt;
              border-left-style: solid;
              border-left-width: 1pt;
              border-left-color: #333333;
              border-bottom-style: solid;
              border-bottom-width: 1pt;
              border-bottom-color: #333333;
              border-right-style: solid;
              border-right-width: 1pt;
              border-right-color: #333333;
            "
          >
            <p style="text-indent: 0pt; text-align: left"><br /></p>
          </td>
        </tr>
        <tr style="height: 26pt">
          <td
            style="
              width: 449pt;
              border-top-style: solid;
              border-top-width: 1pt;
              border-top-color: #333333;
              border-left-style: solid;
              border-left-width: 1pt;
              border-left-color: #333333;
              border-bottom-style: solid;
              border-bottom-width: 2pt;
              border-bottom-color: #333333;
              border-right-style: solid;
              border-right-width: 1pt;
              border-right-color: #333333;
            "
            colspan="2"
          >
            <p
              class="s8"
              style="
                padding-top: 7pt;
                padding-right: 5pt;
                text-indent: 0pt;
                text-align: right;
              "
            >
              Total
            </p>
          </td>
          <td
            style="
              width: 114pt;
              border-top-style: solid;
              border-top-width: 1pt;
              border-top-color: #333333;
              border-left-style: solid;
              border-left-width: 1pt;
              border-left-color: #333333;
              border-bottom-style: solid;
              border-bottom-width: 2pt;
              border-bottom-color: #333333;
              border-right-style: solid;
              border-right-width: 1pt;
              border-right-color: #333333;
            "
          >
            <p
              class="s10"
              style="
                padding-top: 7pt;
                padding-right: 6pt;
                text-indent: 0pt;
                text-align: right;
              "
            >
              ₹ <span class="s8">${data.totalAmount}</span>
            </p>
          </td>
        </tr>
        <tr style="height: 56pt">
          <td
            style="
              width: 563pt;
              border-top-style: solid;
              border-top-width: 2pt;
              border-top-color: #333333;
              border-left-style: solid;
              border-left-width: 1pt;
              border-left-color: #333333;
              border-bottom-style: solid;
              border-bottom-width: 2pt;
              border-bottom-color: #333333;
              border-right-style: solid;
              border-right-width: 1pt;
              border-right-color: #333333;
            "
            colspan="3"
          >
            <p
              class="s6"
              style="
                padding-top: 10pt;
                padding-left: 204pt;
                padding-right: 202pt;
                text-indent: 0pt;
                line-height: 155%;
                text-align: center;
              "
            >
              Invoice amount in words: ${data.amountInWords} Only
            </p>
          </td>
        </tr>
        <tr style="height: 73pt">
          <td
            style="
              width: 563pt;
              border-top-style: solid;
              border-top-width: 2pt;
              border-top-color: #333333;
            "
            colspan="3"
            bgcolor="#F4F4F4"
          >
            <p style="text-indent: 0pt; text-align: left"><br /></p>
          </td>
        </tr>
      </table>
      <p style="text-indent: 0pt; text-align: left" />
      <p style="padding-left: 167pt; text-indent: 0pt; text-align: center">:</p>
    </div>
  </body>
</html>
`;
};

export const UPDATED_PRO_FORMA_INVOICE = (data: ProFormaInvoice): string => {
  return `<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap" rel="stylesheet">
    <style>
        @page {
            size: A4;
            margin: 5mm 20mm;
        }

        * {
            font-family: 'Noto Sans', sans-serif;
            margin: 0;
            padding: 0;
        }
    </style>
</head>

<body>
    <div>

        <div
            style="width:100%; display: flex; flex-direction: column; justify-content: space-between; align-items: center; gap:10px; margin-bottom:20px;">
        <div>
            <img src="https://delta-node-test.s3.ap-south-1.amazonaws.com/redDots.png" alt="Logo"
                style="height:10px; width:45px; margin-bottom: 10px;">
        </div>
        <div style="height: 40px; width:300px; text-align: center;">
            <img src="https://delta-node-test.s3.ap-south-1.amazonaws.com/infinithhesimlogo.png" alt="Logo"
            style="height:100%; width:60%">
        </div>
            <p style="color: #0F377F;
                font-family: Noto Sans;
                font-weight: 500;
                text-align: center;
">infinitheism spiritual foundation private limited</p>
            <p style="
            width: 360px;
            text-align: center;
            font-family: Noto Sans;
            font-weight: 400;
            font-size: 14px;
            ">${data.companyAddress}</p>
            <a style="color:#2035F3;  font-size: 18px; font-family: Inter;" href="www.infinitheism.com">www.infinitheism.com</a>
            <p style="font-family: Noto Sans;
            font-size: 14px;
            font-weight: 400;
            text-align: center;
            ">PAN: ${data.companyPAN} | GSTIN: ${data.companyGST} | CIN: ${data.companyCIN}</p>
        </div>
        <div style="width:100%; display: flex; justify-content: space-between; align-items: flex-end;padding: 15px 0px;
         border-top: 1px solid #7D7D7D; border-bottom: 1px solid #7D7D7D;">
            <div>
                <p style="font-size: 16px; font-family: Noto Sans;font-weight: 500;color :#000000">Pro-Forma Invoice</p>
                <p style="font-size: 14px; font-family: Noto Sans;color :#000000">Invoice No:${data.invoiceNumber}</p>
                <p style="font-size: 14px; font-family: Noto Sans;color :#000000">Date: ${data.currentDate}</p>
            </div>
        </div>
        <div style="width:100%; display: flex; justify-content: space-between; align-items: flex-end;padding: 15px 0px;">
            <div>
                <p style="font-size: 16px; font-family: Noto Sans;font-weight: 500;color :#000000">Bill To</p>
                <p style="font-size: 14px; font-family: Noto Sans;color :#000000">${data.seekerName}</p>
                <p style="font-size: 14px; font-family: Noto Sans;color :#000000">${data.seekerAddress}</p>
            </div>
        </div>

        <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
            <thead>
                <tr>
                    <th style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px;text-align: left;font-size: 16px;font-weight: 500;">Particulars</th>
                    <th style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px ; text-align: right;font-size: 16px;font-weight: 500;">Amount</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px ;font-size: 14px;">${data.programName} from
                        (${data.reportingTime} to ${data.checkOutTime}) SAC: 999293</td>
                    <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px ; text-align: right;font-size: 14px;">₹ ${data.amount}</td>
                </tr>
                 <tr>
                    <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px;font-size: 14px;">GST @ ${data.gstPercentage}%</td>
                    <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px ; width:30%; text-align: right;font-size: 14px;">₹ ${data.gstAmount}</td>
                </tr>
        <tr>
        <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px;font-size: 14px;"> Amount includes accommodation and food </td>
        <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; height:35px ; width:30%; text-align: right;font-size: 14px;"></td>
    </tr>
                 <tr>
                    <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; text-align: left; font-weight: 500; height:35px;font-size: 16px;">Total</td>
                    <td style="font-family: Noto Sans;border: 1px solid #7D7D7D; padding: 10px; text-align: right; font-weight: 500;width:30%; height:35px;font-size: 16px;">₹ ${data.totalAmount}</td>
                </tr>
            </tbody>
        </table>
        <div style="margin-top: 10px;">
            <p style="font-family: Noto Sans;margin: 5px 0;font-size: 14px;">Invoice amount in words: ${data.amountInWords} only</p>
        </div>
        <hr style="border: 1px solid #7D7D7D; margin: 20px 0;" />
        <p style="font-family: Noto Sans;margin-top: 20px;font-size: 14px;text-align:center;">(Note: this is computer generated invoice and hence signature is not required)</p>
    </div>
</body>

</html>`;
};