import { ERROR_MESSAGES } from "../i18n/error-messages";


export class ErrorMessageService {
  /**
   * Retrieves the error message template for a given error code.
   * @param code - The error code.
   * @returns The error message template or a default message if the code is not found.
   */
  static getTemplate(code: string): string {
    return ERROR_MESSAGES[code] || 'Unknown error';
  }

  /**
   * Retrieves the error message by replacing placeholders in the template with the provided arguments.
   * @param args - Arguments to replace placeholders in the error message.
   * @param template - The error message template.
   * @returns The formatted error message.
   */
  static getMessage(template: string, args: string[] = []): string {
    return args.reduce((msg, arg, index) => msg.replace(`{${index}}`, arg), template);
  }
}