import { ErrorMessageService } from "../services/error-message.service";

export abstract class MainInifniException implements IInfiniException {
  code: string;
  message: string;
  name: string = 'MainInifniException';
  error: Error | null;
  details?: any;

  /**
   * Constructs a new exception.
   * @param code - The error code.
   * @param error - Optional error object (can be null).
   * @param details - Additional details for the error.
   * @param args - Arguments to replace placeholders in the error message.
   */
  constructor(code: string, error: Error | null = null, details?: any, ...args: string[]) {
    this.code = code;
    this.error = error;
    this.details = details;

    // Get the error message template
    const template = ErrorMessageService.getTemplate(code);

    // Format the message using the template and arguments
    this.message = ErrorMessageService.getMessage(template,args);
  }

  /**
   * Returns a string representation of the exception.
   */
  toString() {
    return `${this.name} - ${this.code}: ${this.message} - ${this.details}`;
  }

  /**
   * Returns a detailed string representation of the exception.
   */
  toStringDetail() {
    return `${this.name} - ${this.code}: ${this.message} - ${this.details} - [${this.error?.message || 'No additional error'}]`;
  }
}