import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  OneToMany,
  ManyToMany,
  JoinTable,
} from 'typeorm';
import { UserRoleMap } from './user-role-map.entity';
import { UserTypeEnum } from '../enum/user-type.enum';
import { UserRole } from './user-role.entity';

@Entity('users')
export class User {
  @PrimaryGeneratedColumn({ name: 'id' })
  id: number;

  @Column({ name: 'phone_number', type: 'varchar', length: 255, nullable: true })
  phoneNumber: string;

  @Column({ name: 'full_name', type: 'varchar', length: 255, nullable: true })
  fullName: string;

  @Column({ name: 'role', type: 'varchar', length: 255, nullable: false })
  role: string;

  @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP', onUpdate: 'CURRENT_TIMESTAMP' })
  updatedAt: Date;

  @Column({ name: 'is_infiminute', type: 'boolean', nullable: true, default: true })
  isInfiminute: boolean;

  @Column({ name: 'is_infimessages', type: 'boolean', nullable: true })
  isInfimessages: boolean;

  @Column({ name: 'user_approval_status', type: 'varchar', length: 20, nullable: true })
  userApprovalStatus: string;

  @Column({ name: 'first_name', type: 'varchar', length: 255, nullable: true })
  firstName: string;

  @Column({ name: 'last_name', type: 'varchar', length: 255, nullable: true })
  lastName: string;

  @Column({ name: 'status_updated_at', type: 'timestamp', nullable: true })
  statusUpdatedAt: Date;

  @Column({ name: 'is_infipath', type: 'boolean', nullable: true, default: true })
  isInfipath: boolean;

  @Column({ name: 'email', type: 'varchar', length: 319, nullable: true })
  email: string;

  @Column({ name: 'is_infimessage_user_active', type: 'boolean', nullable: true, default: true })
  isInfimessageUserActive: boolean;

  @Column({ name: 'is_infipath_user_active', type: 'boolean', nullable: true })
  isInfipathUserActive: boolean;

  @Column({ name: 'name_audio', type: 'varchar', nullable: true })
  nameAudio: string;

  @Column({ name: 'is_infiminute_user_active', type: 'boolean', nullable: true, default: true })
  isInfiminuteUserActive: boolean;

  @Column({ name: 'profile_url', type: 'varchar', nullable: true })
  profileUrl: string;

  @Column({ name: 'address', type: 'text', nullable: true })
  address: string;

  @Column({ name: 'country_code', type: 'varchar', length: 7, nullable: true })
  countryCode: string;

  @Column({ name: 'associated_since', type: 'date', nullable: true })
  associatedSince: Date;

  @Column({ name: 'gender', type: 'varchar', length: 10, nullable: true })
  gender: string;

  @Column({ name: 'dob', type: 'date', nullable: true })
  dob: Date;

  @Column({ name: 'other_address', type: 'text', nullable: true })
  otherAddress: string;

  @Column({ name: 'firebase_id_ext', type: 'varchar', length: 255, nullable: true })
  firebaseIdExt: string;

  @Column({ name: 'acknowledgement_date', type: 'timestamptz', nullable: true })
  acknowledgementDate: Date;

  @Column({ name: 'terms_and_conditions', type: 'boolean', default: false })
  termsAndConditions: boolean;

  @Column({ name: 'alternate_country_code', type: 'varchar', length: 255, nullable: true })
  alternateCountryCode: string;

  @Column({ name: 'alternate_phone_number', type: 'varchar', length: 255, nullable: true })
  alternatePhoneNumber: string;

  @Column({ name: 'alternate_email', type: 'varchar', length: 255, nullable: true })
  alternateEmail: string;

  @Column({ name: 'encrypted_phone_number', type: 'varchar', length: 1024, nullable: true })
  encryptedPhoneNumber: string;

  @Column({ name: 'masked_phone_number', type: 'varchar', length: 1024, nullable: true })
  maskedPhoneNumber: string;

  @Column({ name: 'encrypted_email', type: 'varchar', length: 1024, nullable: true })
  encryptedEmail: string;

  @Column({ name: 'is_system_user', type: 'boolean', default: false })
  isSystemUser: boolean;

  @Column({ name: 'is_ai_user', type: 'boolean', default: false })
  isAiUser: boolean;

  @Column({
    name: 'user_type',
    type: 'enum',
    enum: UserTypeEnum,
    default: UserTypeEnum.SEEKER,
    nullable: true,
  })
  userType: UserTypeEnum;

  @Column({
    name: 'legal_full_name',
    type: 'varchar', 
    length: 255,
  })
  legalFullName: string;
  
  @OneToMany(() => UserRoleMap, (urm) => urm.user)
  userRoleMaps: UserRoleMap[];

  @ManyToMany(() => UserRole,)
  @JoinTable({
    name: 'user_role_map',
    joinColumn: { name: 'user_id', referencedColumnName: 'id' },
    inverseJoinColumn: { name: 'role_id', referencedColumnName: 'id' }
  })
  userRoles: UserRole[];

  constructor(partial: Partial<User>) {
    Object.assign(this, partial);
  }
}