import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  ManyToOne,
  JoinColumn,
  DeleteDateColumn,
} from 'typeorm';
import { TravelTypeEnum } from '../enum/travel-type.enum';
import { User, ProgramRegistration } from '../entities/index';
import { TravelStatusEnum } from '../enum/travel-status.enum';


@Entity('hdb_registration_travel_plan')
export class RegistrationTravelPlan {
  @PrimaryGeneratedColumn('increment', { type: 'bigint' })
  id: number;

  @Column({ name: 'registration_id', type: 'bigint' })
  registrationId: number;

  @Column({ name: 'travel_type', type: 'enum', enum: TravelTypeEnum })
  travelType: TravelTypeEnum | null;

  @Column({ name: 'return_travel_type', type: 'enum', enum: TravelTypeEnum, nullable: true })
  returnTravelType: TravelTypeEnum | null;

  @Column({ name: 'airline_name', type: 'varchar', length: 100, nullable: true })
  airlineName: string;

  @Column({ name: 'flight_number', type: 'varchar', length: 20, nullable: true })
  flightNumber: string;

  @Column({ name: 'arrival_datetime', type: 'timestamp', nullable: true })
  arrivalDatetime: Date;

  @Column({ name: 'departure_location', type: 'varchar', length: 255, nullable: true })
  departureLocation: string;

  @Column({ name: 'pickup_time', type: 'time', nullable: true })
  pickupTime: string;

  @Column({ name: 'pickup_location', type: 'varchar', length: 255, nullable: true })
  pickupLocation: string;

  @Column({ name: 'checkin_at', type: 'timestamptz', nullable: true })
  checkinAt: Date;

  @Column({ name: 'checkin_location', type: 'varchar', length: 255, nullable: true })
  checkinLocation: string;

  @Column({
    name: 'travel_plan_status',
    type: 'enum',
    enum: TravelStatusEnum,
    default: TravelStatusEnum.PENDING,
  })
  travelPlanStatus: TravelStatusEnum;

  @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP', onUpdate: 'CURRENT_TIMESTAMP' })
  updatedAt: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamptz', nullable: true, default: null })
  deletedAt: Date;
    
  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'created_by' })
  createdBy: User;

  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'updated_by' })
  updatedBy: User;

  @ManyToOne(() => ProgramRegistration, { nullable: false, onDelete: 'CASCADE' })
  @JoinColumn({ name: 'registration_id' })
  registration: ProgramRegistration;

  constructor(partial: Partial<RegistrationTravelPlan>) {
    Object.assign(this, partial);
  }
}