  import {
    Entity,
    PrimaryGeneratedColumn,
    Column,
    CreateDateColumn,
    UpdateDateColumn,
    ManyToOne,
    JoinColumn,
    DeleteDateColumn,
  } from 'typeorm';
  import { IdTypeEnum } from '../enum/proof-id-type.enum';
  import { TshirtSizeEnum } from '../enum/tshirt-size.enum';
  import { TravelStatusEnum } from '../enum/travel-status.enum';
  import { ProgramRegistration, User } from '../entities/index'
  
  @Entity('hdb_registration_travel_info')
  export class RegistrationTravelInfo {
    @PrimaryGeneratedColumn('increment', { type: 'bigint' })
    id: number;
  
    @Column({ name: 'registration_id', type: 'bigint' })
    registrationId: number;
  
    @Column({ name: 'id_type', type: 'enum', enum: IdTypeEnum })
    idType: IdTypeEnum;
  
    @Column({ name: 'id_number', type: 'varchar', length: 50 })
    idNumber: string;
  
    @Column({ name: 'id_picture_url', type: 'varchar', length: 500, nullable: true })
    idPictureUrl: string;
  
    @Column({ name: 'user_picture_url', type: 'varchar', length: 500, nullable: true })
    userPictureUrl: string;
  
    @Column({ name: 'tshirt_size', type: 'enum', enum: TshirtSizeEnum, nullable: true })
    tshirtSize: TshirtSizeEnum;

    @Column({
      name: 'travel_info_status',
      type: 'enum',
      enum: TravelStatusEnum,
      default: TravelStatusEnum.PENDING,
    })
    travelInfoStatus: TravelStatusEnum;
  
   @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
    createdAt: Date;
   
    @UpdateDateColumn({ name: 'updated_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP', onUpdate: 'CURRENT_TIMESTAMP' })
    updatedAt: Date;
  
    @DeleteDateColumn({ name: 'deleted_at', type: 'timestamptz', nullable: true, default: null })
    deletedAt: Date;
    
    @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
    @JoinColumn({ name: 'created_by' })
    createdBy: User;
  
    @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
    @JoinColumn({ name: 'updated_by' })
    updatedBy: User;
  
    @ManyToOne(() => ProgramRegistration, { nullable: false, onDelete: 'CASCADE' })
    @JoinColumn({ name: 'registration_id' })
    registration: ProgramRegistration;
  
    constructor(partial: Partial<RegistrationTravelInfo>) {
      Object.assign(this, partial);
    }
  }