import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  ManyToOne,
  JoinColumn,
  DeleteDateColumn,
} from 'typeorm';
import { PaymentModeEnum } from '../enum/payment-mode.enum';
import { PaymentStatusEnum } from '../enum/payment-status.enum';
import { ProgramRegistration, ProgramSession, User } from '../entities/index';

@Entity('hdb_registration_payment_detail')
export class RegistrationPaymentDetail {
  @PrimaryGeneratedColumn('increment', { type: 'bigint' })
  id: number;

  @Column({ name: 'registration_id', type: 'bigint' })
  registrationId: number;

  @Column({ name: 'program_session_id', type: 'bigint' })
  programSessionId: number;

  @Column({ name: 'payment_mode', type: 'enum', enum: PaymentModeEnum })
  paymentMode: PaymentModeEnum;

  @Column({ name: 'tax_amount', type: 'decimal', precision: 10, scale: 2, default: 0.00 })
  taxAmount: number;

  @Column({ name: 'tds', type: 'decimal', precision: 10, scale: 2, default: 0.00 })
  tds: number;

  @Column({ name: 'sub_total', type: 'decimal', precision: 10, scale: 2, default: 0.00 })
  subTotal: number;

  @Column({ name: 'razorpay_id', type: 'varchar', length: 100, nullable: true })
  razorpayId: string;

  @Column({ name: 'offline_meta', type: 'jsonb', nullable: true })
  offlineMeta: Record<string, any>;

  @Column({ name: 'original_amount', type: 'decimal', precision: 10, scale: 2, default: 0.00 })
  originalAmount: number;

  @Column({ name: 'gst_amount', type: 'decimal', precision: 10, scale: 2, default: 0.00 })
  gstAmount: number;

  @Column({
    name: 'payment_status',
    type: 'enum',
    enum: PaymentStatusEnum,
    default: PaymentStatusEnum.DRAFT,
  })
  paymentStatus: PaymentStatusEnum;

  @Column({ name: 'mark_as_received_date', type: 'timestamptz', nullable: true })
  markAsReceivedDate: Date;

  @Column({ name: 'payment_date', type: 'timestamptz', nullable: true })
  paymentDate: Date;

  @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP', onUpdate: 'CURRENT_TIMESTAMP' })
  updatedAt: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamptz', nullable: true, default: null })
  deletedAt: Date;

  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'created_by' })
  createdBy: User;

  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'updated_by' })
  updatedBy: User;

  @ManyToOne(() => ProgramRegistration, { nullable: false, onDelete: 'CASCADE' })
  @JoinColumn({ name: 'registration_id' })
  registration: ProgramRegistration;

  @ManyToOne(() => ProgramSession, { nullable: false, onDelete: 'CASCADE' })
  @JoinColumn({ name: 'program_session_id' })
  programSession: ProgramSession;

  constructor(partial: Partial<RegistrationPaymentDetail>) {
    Object.assign(this, partial);
  }
}