import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  ManyToOne,
  JoinColumn,
  DeleteDateColumn,
} from 'typeorm';
import { InvoiceTypeEnum } from '../enum/invoice-type.enum';
import { InvoiceStatusEnum } from '../enum/invoice-status.enum';
import { ProgramRegistration, User } from  '../entities/index'

@Entity('hdb_registration_invoice_detail')
export class RegistrationInvoiceDetail {
  @PrimaryGeneratedColumn('increment', { type: 'bigint' })
  id: number;

  @Column({ name: 'registration_id', type: 'bigint' })
  registrationId: number;

  @Column({ name: 'invoice_type', type: 'enum', enum: InvoiceTypeEnum })
  invoiceType: InvoiceTypeEnum;

  @Column({ name: 'invoice_name', type: 'varchar', length: 255 })
  invoiceName: string;

  @Column({ name: 'invoice_email', type: 'varchar', length: 255 })
  invoiceEmail: string;

  @Column({ name: 'pan_number', type: 'varchar', length: 20, nullable: true })
  panNumber: string;

  @Column({ name: 'is_gst_registered', type: 'boolean', default: false })
  isGstRegistered: boolean;

  @Column({ name: 'invoice_address', type: 'text' })
  invoiceAddress: string;

  @Column({ name: 'tax_amount', type: 'decimal', precision: 10, scale: 2, default: 0.00 })
  taxAmount: number;

  @Column({ name: 'invoice_sequence_number', type: 'varchar', length: 50, nullable: true })
  invoiceSequenceNumber: string;

  @Column({ name: 'razorpay_id', type: 'varchar', length: 100, nullable: true })
  razorpayId: string;

  @Column({ name: 'invoice_issued_date', type: 'timestamptz', nullable: true })
  invoiceIssuedDate: Date;

  @Column({
    name: 'invoice_status',
    type: 'enum',
    enum: InvoiceStatusEnum,
    default: InvoiceStatusEnum.DRAFT,
  })
  invoiceStatus: InvoiceStatusEnum;

  @Column({ name: 'tds_applicable', type: 'boolean', default: false })
  tdsApplicable: boolean;

  @Column({ name: 'tan_number', type: 'varchar', length: 20, nullable: true })
  tanNumber: string;

  @Column({ name: 'handover_date', type: 'timestamptz', nullable: true })
  handoverDate: Date;

  @Column({ name: 'handover_to', type: 'varchar', length: 255, nullable: true })
  handoverTo: string;

   @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
     createdAt: Date;
   
    @UpdateDateColumn({ name: 'updated_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP', onUpdate: 'CURRENT_TIMESTAMP' })
    updatedAt: Date;
  
    @DeleteDateColumn({ name: 'deleted_at', type: 'timestamptz', nullable: true, default: null })
    deletedAt: Date;
    
    @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
    @JoinColumn({ name: 'created_by' })
    createdBy: User;
  
    @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
    @JoinColumn({ name: 'updated_by' })
    updatedBy: User;

  @Column({ name: 'gst_number', type: 'varchar', length: 50, nullable: true })
  gstNumber: string;

  @Column({ name: 'zip', type: 'varchar', length: 10, nullable: true })
  zip: string;

  @Column({ name:'tds_amount', type: 'numeric', precision: 10, scale: 2, nullable: true })
  tdsAmount: number;
  
  @Column({ name: 'einvoice_qr_link', type: 'varchar', length: 1024, nullable: true })
  einvoiceQrLink: string;

  @Column({ name: 'einvoice_ack_date', type: 'varchar', length: 500, nullable: true })
  einvoiceAckDate: string;

  @Column({ name: 'einvoice_inv_ref_num', type: 'varchar', length: 1024, nullable: true })
  einvoiceInvRefNum: string;

  @Column({ name: 'einvoice_is_cancellable', type: 'boolean', nullable: true })
  einvoiceIsCancellable: boolean;

  @Column({ name: 'einvoice_status_formatted', type: 'varchar', length: 1024, nullable: true })
  einvoiceStatusFormatted: string;

  @Column({ name: 'einvoice_formatted_status', type: 'varchar', length: 500, nullable: true })
  einvoiceFormattedStatus: string;

  @Column({ name: 'einvoice_ack_number', type: 'varchar', length: 500, nullable: true })
  einvoiceAckNumber: string;

  @Column({ name: 'einvoice_status', type: 'varchar', length: 500, nullable: true })
  einvoiceStatus: string;
  
  @Column({ name: 'invoice_pdf_url', type: 'varchar', length: 2048, nullable: true })
  invoicePdfUrl: string;

  @ManyToOne(() => ProgramRegistration, { nullable: false, onDelete: 'CASCADE' })
  @JoinColumn({ name: 'registration_id' })
  registration: ProgramRegistration;

  constructor(partial: Partial<RegistrationInvoiceDetail>) {
    Object.assign(this, partial);
  }
}
