import {
    Entity,
    PrimaryGeneratedColumn,
    Column,
    CreateDateColumn,
    UpdateDateColumn,
    ManyToOne,
    JoinColumn,
    DeleteDateColumn,
  } from 'typeorm';
import { ApprovalStatusEnum } from '../enum/approval-status.enum';
import { ProgramRegistration, User } from '../entities/index'
  
  @Entity('hdb_registration_approval')
  export class RegistrationApproval {
    @PrimaryGeneratedColumn('increment', { type: 'bigint' })
    id: number;
  
    @Column({ name: 'registration_id', type: 'bigint' })
    registrationId: number;
  
    @Column({ name: 'approval_status', type: 'enum', enum: ApprovalStatusEnum, default: ApprovalStatusEnum.PENDING })
    approvalStatus: ApprovalStatusEnum;
  
    @Column({ name: 'approval_date', type: 'timestamptz', nullable: true })
    approvalDate: Date;
  
    @Column({ name: 'approved_by', type: 'bigint', nullable: true })
    approvedBy: number;
  
    @Column({ name: 'rejection_reason', type: 'text', nullable: true })
    rejectionReason: string;
  
    @Column({ name: 'reviewer_comments', type: 'text', nullable: true })
    reviewerComments: string;
  
    @Column({ name: 'auto_approved', type: 'boolean', default: false })
    autoApproved: boolean;
  
    @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
      createdAt: Date;
    
    @UpdateDateColumn({ name: 'updated_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP', onUpdate: 'CURRENT_TIMESTAMP' })
    updatedAt: Date;
  
    @DeleteDateColumn({ name: 'deleted_at', type: 'timestamptz', nullable: true, default: null })
    deletedAt: Date;
    
    @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
    @JoinColumn({ name: 'created_by' })
    createdBy: User;
  
    @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
    @JoinColumn({ name: 'updated_by' })
    updatedBy: User;

    @ManyToOne(() => ProgramRegistration, { nullable: false, onDelete: 'CASCADE' })
    @JoinColumn({ name: 'registration_id' })
    registration: ProgramRegistration;
  
    @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
    @JoinColumn({ name: 'approved_by' })
    approvedByUser: User;
  
    constructor(partial: Partial<RegistrationApproval>) {
      Object.assign(this, partial);
    }
  }