import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  DeleteDateColumn,
  ManyToOne,
  JoinColumn,
  OneToMany,
} from 'typeorm';
import { User } from './user.entity';
import { QuestionOptionMap } from './question-option.entity';
import { CommonStatus } from '../enum/common-status.enum';
import { FormSection, ProgramQuestion } from './index';

@Entity('hdb_question')
export class Question {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ name: 'label', type: 'varchar', length: 1024 })
  label: string;

  @Column({ name: 'config', type: 'jsonb', nullable: true })
  config: Record<string, any>;

  @Column({ name: 'stats', type: 'enum', enum: CommonStatus, default: 'draft' })
  status: string;

  @Column({ name: 'typ', type: 'varchar', length: 50 })
  type: string;

  @Column({name: 'answer_location', type: 'varchar', length: 1024, nullable: true})
  answerLocation: string;

  @Column({name: 'binding_key', type: 'varchar', length: 255, nullable: true})
  bindingKey: string;

  @CreateDateColumn({ name: 'created_at', type: 'timestamptz' })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamptz' })
  updatedAt: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamptz', nullable: true })
  deletedAt: Date;

  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'created_by' })
  createdBy: User;

  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'updated_by' })
  updatedBy: User;


  @ManyToOne(() => FormSection, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'form_section_id' })
  formSection: FormSection;

  @OneToMany(() => QuestionOptionMap, (questionOptionMap) => questionOptionMap.question)
  questionOptionMaps: QuestionOptionMap[];

  @OneToMany(() => ProgramQuestion, pqm => pqm.question)
  programQuestionMaps: ProgramQuestion[];

  constructor(partial: Partial<Question>) {
    Object.assign(this, partial);
  }
}