import { GenderEnum } from '../enum/gender.enum';
import { RegistrationStatusEnum } from '../enum/registration-status.enum';
import { RegistrationBasicStatusEnum } from '../enum/registration-basic-status.enum';
import { Column, CreateDateColumn, DeleteDateColumn, Entity, JoinColumn, ManyToOne, OneToMany, PrimaryGeneratedColumn, UpdateDateColumn } from 'typeorm';
import { Preference, Program, ProgramRegistrationRmRating, ProgramRegistrationSwap, ProgramSession, RegistrationApproval, RegistrationCustomResponse, RegistrationInvoiceDetail, RegistrationPaymentDetail, RegistrationTravelInfo, User } from '../entities/index'
import { RegistrationTravelPlan } from './registration-travel-plan.entity';

@Entity('hdb_program_registration')
export class ProgramRegistration {
  @PrimaryGeneratedColumn('increment', { type: 'bigint' })
  id: number;
  
  @ManyToOne(() => Program, { nullable: true })
  @JoinColumn({ name: 'program_id' })
  program: Program;

  @ManyToOne(() => ProgramSession, { nullable: false, onDelete: 'CASCADE' })
  @JoinColumn({ name: 'program_session_id' })
  programSession: ProgramSession;

  @ManyToOne(() => Program, { nullable: true })
  @JoinColumn({ name: 'allocated_program_id' })
  allocatedProgram?: Program | null;

  @ManyToOne(() => ProgramSession, { nullable: true })
  @JoinColumn({ name: 'allocated_session_id' })
  allocatedSession?: ProgramSession | null;

  @Column({ name: 'user_id', type: 'bigint', nullable: true })
  userId: number;

  // @Column({ name: 'program_registration_seq_number', type: 'integer', nullable: true })
  // programRegistrationSeqNumber: number;

  @Column({ name: 'registration_seq_number', type: 'varchar', length: 50, nullable: true })
  registrationSeqNumber: string;

  @Column({ name: 'waiting_list_seq_number', type: 'integer', nullable: true })
  waitingListSeqNumber: number;

  @Column({ name: 'wait_list_registration_seq_number', type: 'varchar', length: 50, nullable: true })
  waitListRegistrationSeqNumber: string;

  @Column({
    name: 'registration_status',
    type: 'enum',
    enum: RegistrationStatusEnum,
    default: RegistrationStatusEnum.DRAFT,
  })
  registrationStatus: RegistrationStatusEnum;

  @Column({
    name: 'basic_details_status',
    type: 'enum',
    enum: RegistrationBasicStatusEnum,
    default: RegistrationBasicStatusEnum.DRAFT,
  })
  basicDetailsStatus: RegistrationBasicStatusEnum;

  @Column({ name: 'registration_date', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  registrationDate: Date;

  @Column({ name: 'cancellation_date', type: 'timestamptz', nullable: true })
  cancellationDate: Date;

  @Column({ name: 'cancelled_by', type: 'bigint', nullable: true })
  cancelledBy: number;

  @Column({ name: 'rm_contact', type: 'bigint', nullable: true })
  rmContact: number;

  @Column({ name: 'preferred_room_mate', type: 'varchar', length: 255, nullable: true })
  preferredRoomMate: string;

  @Column({ name: 'full_name', type: 'varchar', length: 255 })
  fullName: string;

  @Column({ name: 'gender', type: 'enum', enum: GenderEnum })
  gender: GenderEnum;

  @Column({ name: 'mobile_number', type: 'varchar', length: 20 })
  mobileNumber: string;

  @Column({ name: 'email_address', type: 'varchar', length: 255 })
  emailAddress: string;

  @Column({ name: 'dob', type: 'date', nullable: true })
  dob: Date;

  @Column({ name: 'city', type: 'varchar', length: 100, nullable: true })
  city: string;

  @Column({ name: 'notes', type: 'text', nullable: true })
  notes: string;

  @Column({ name: 'terms_accepted', type: 'boolean', default: false })
  termsAccepted: boolean;

  @Column({ name : 'rm_review', type: 'text', nullable: true })
  rmReview: string;


  @Column({name: 'no_of_hdbs', type: 'integer', default: 0})
  noOfHDBs: number;

  @Column({ name: 'user_profile_url', type: 'text' })
  profileUrl: string;

  @Column({ name: 'user_video_url', type: 'text', nullable: true })
  videoUrl: string;

  @Column({ name:"pro_forma_invoice_name", type: 'varchar', length: 255, nullable: true })
  proFormaInvoiceName: string;

  @Column({ name: 'pro_forma_invoice_address', type: 'text', nullable: true })
  proFormaInvoiceAddress: string;

  @Column({ name: 'pro_forma_invoice_pdf_url', type: 'text', nullable: true })
  proFormaInvoicePdfUrl: string;

  @Column({ name: 'proforma_invoice_seq_number', type: 'varchar', length: 225, nullable: true })
  proFormaInvoiceSeqNumber: string;

  @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP', onUpdate: 'CURRENT_TIMESTAMP' })
  updatedAt: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamptz', nullable: true, default: null })
  deletedAt: Date;

  @ManyToOne(() => User, { nullable: true, onDelete: 'CASCADE' })
  @JoinColumn({ name: 'user_id' })
  user: User;

  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'cancelled_by' })
  cancelledByUser: User;

  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'rm_contact' })
  rmContactUser: User;

  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'created_by' })
  createdBy: User;

  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'updated_by' })
  updatedBy: User;

  @OneToMany(() => RegistrationInvoiceDetail, (invoice) => invoice.registration)
  invoiceDetails: RegistrationInvoiceDetail[];

  @OneToMany(() => RegistrationPaymentDetail, (payment) => payment.registration)
  paymentDetails: RegistrationPaymentDetail[];

  @OneToMany(() => RegistrationTravelInfo, (travelInfo) => travelInfo.registration)
  travelInfo: RegistrationTravelInfo[];

  @OneToMany(() => RegistrationTravelPlan, (travelPlans) => travelPlans.registration)
  travelPlans: RegistrationTravelPlan[];

  @OneToMany(() => RegistrationCustomResponse, (customResponse) => customResponse.registration)
  customResponses: RegistrationCustomResponse[];

  @OneToMany(() => RegistrationApproval, (approval) => approval.registration)
  approvals: RegistrationApproval[];

  @OneToMany(() => Preference, (preference) => preference.registration)
  preferences: Preference[];

  @OneToMany(() => ProgramRegistrationRmRating, (rating) => rating.programRegistration)
  @JoinColumn({ name: 'program_registration_id' })
  ratings: ProgramRegistrationRmRating[];

  @OneToMany(() => ProgramRegistrationSwap, (swap) => swap.programRegistration)
  @JoinColumn({ name: 'program_registration_id' , referencedColumnName: 'id' })
  swapsRequests: ProgramRegistrationSwap[];

  constructor(partial: Partial<ProgramRegistration>) {
    Object.assign(this, partial);
  }
}