import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  JoinColumn,
  OneToOne,
  ManyToOne,
  ManyToMany,
  JoinTable,
} from 'typeorm';
import { ProgramRegistration } from './program-registration.entity';
import { Program } from './program.entity';

@Entity('hdb_program_registration_swap')
export class ProgramRegistrationSwap {
  @PrimaryGeneratedColumn('increment', { name: 'id', type: 'bigint' })
  id: number;

  @Column({ name: 'program_registration_id', type: 'bigint', })
  programRegistrationId: number;

  @OneToOne(() => ProgramRegistration, )
  @JoinColumn({ name: 'program_registration_id', referencedColumnName: 'id' })
  programRegistration?: ProgramRegistration;

  @Column({ name: 'type', type: 'varchar', length: 255 })
  type: string;

  @Column({ name: 'status', type: 'varchar', length: 255 })
  status: string;

  @Column({ name: 'comment', type: 'text' })
  comment: string;

  @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamptz' , default: () => 'CURRENT_TIMESTAMP', onUpdate: 'CURRENT_TIMESTAMP' })
  updatedAt: Date;

  @Column({ name: 'created_by', type: 'bigint', })
  createdBy: number;

  @Column({ name: 'updated_by', type: 'bigint', })
  updatedBy: number;

  @Column({ name: 'current_program_id', type: 'bigint' })
  currentProgramId: number;

  @ManyToOne(() => Program, {
    nullable: true,
  })
  @JoinColumn({ name: 'current_program_id', referencedColumnName: 'id' })
  currentProgram: Program;
  
  @Column({ name: 'allocated_program_id', type: 'bigint' })
  allocatedProgramId: number;
  
  @ManyToOne(() => Program, {
    nullable: true,
  })  
  @JoinColumn({ name: 'allocated_program_id', referencedColumnName: 'id' })
  allocatedProgram: Program;

  @ManyToMany(() => Program, { nullable: true })
  @JoinTable({
    name: 'hdb_swap_requested_program',
    joinColumn: {
      name: 'swap_request_id',
      referencedColumnName: 'id',
    },
    inverseJoinColumn: {
      name: 'program_id',
      referencedColumnName: 'id',
    },
  })
  requestedPrograms?: Program[];
}
