import {
  Column,
  CreateDateColumn,
  DeleteDateColumn,
  Entity,
  JoinColumn,
  ManyToOne,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';
import { ProgramRegistration } from './program-registration.entity';
import { User } from './user.entity';
import { ProgramRegistrationRmRatingType } from './program-registration-rm-rating-type.entity';

@Entity('hdb_program_registration_rm_rating')
export class ProgramRegistrationRmRating {
  @PrimaryGeneratedColumn('increment', { name: 'id', type: 'bigint' })
  id: number;

  @Column({ name: 'program_registration_id', type: 'bigint', nullable: false })
  programRegistrationId: number;

  @ManyToOne(() => ProgramRegistration,)
  @JoinColumn({ name: 'program_registration_id', referencedColumnName: 'id' })
  programRegistration?: ProgramRegistration;

  @Column({ name: 'rm_id', type: 'bigint', nullable: false })
  rmId: number;

  @ManyToOne(() => User, { nullable: false })
  @JoinColumn({ name: 'rm_id', referencedColumnName: 'id' })
  rm?: User;

  @Column({ name: 'rating_key', type: 'bigint', nullable: false })
  ratingKey: string;

  @ManyToOne(() => ProgramRegistrationRmRatingType, { nullable: false })
  @JoinColumn({ name: 'rating_key', referencedColumnName: 'ratingKey' })
  ratingType?: ProgramRegistrationRmRatingType;

  @Column({ name: 'rating', type: 'integer', nullable: false })
  rating: number;

  @CreateDateColumn({ name: 'created_at', type: 'timestamptz', nullable: true })
  createdAt?: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamptz', nullable: true })
  updatedAt?: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamp', nullable: true })
  deletedAt?: Date;

  @Column({ name: 'created_by', type: 'bigint' })
  createdBy: number;

  @Column({ name: 'updated_by', type: 'bigint' })
  updatedBy: number;
}
