import {
  Column,
  CreateDateColumn,
  Entity,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity('hdb_program_registration_rm_rating_type')
export class ProgramRegistrationRmRatingType {
  @PrimaryGeneratedColumn('increment', { name: 'id', type: 'bigint' })
  id: number;

  @Column({ name: 'rating_key', type: 'varchar', length: 255, unique: true, nullable: false })
  ratingKey: string;

  @Column({ name: 'name', type: 'varchar', length: 255, nullable: false })
  name: string;

  @CreateDateColumn({ name: 'created_at', type: 'timestamp', nullable: true })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamp', nullable: true })
  updatedAt: Date;

  @Column({ name: 'created_by', type: 'bigint', nullable: false })
  createdBy: number;
  
  @Column({ name: 'updated_by', type: 'bigint', nullable: false })
  updatedBy: number;
}
