import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  JoinColumn,
  CreateDateColumn,
} from 'typeorm';
import { Program, User, UserRole } from './index';

@Entity('program_message')
export class Message {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ name: 'program_id' })
  programId: number;

  @Column({ name: 'seeker_id' })
  seekerId: number;

  @Column({ name: 'sender_id' })
  senderId: number;

  @Column({ name: 'receiver_id', nullable: true })
  receiverId?: number;

  @Column({ name: 'receiver_role_flag', default: false })
  receiverRoleFlag: boolean;

  @Column({ name: 'cc_role_id', nullable: true })
  receiverRoleId?: number;

  @Column({ name: 'content', type: 'text' })
  content: string;

  @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'created_by' })
  createdBy: User;

  @ManyToOne(() => Program, { nullable: false })
  @JoinColumn({ name: 'program_id' })
  program: Program;

  @ManyToOne(() => User, { nullable: false })
  @JoinColumn({ name: 'seeker_id' })
  seeker: User;

  @ManyToOne(() => User, { nullable: false })
  @JoinColumn({ name: 'sender_id' })
  sender: User;

  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'receiver_id' })
  receiver: User;

  @ManyToOne(() => UserRole, { nullable: true })
  @JoinColumn({ name: 'cc_role_id' })
  receiverRole: UserRole;

  constructor(partial: Partial<Message>) {
    Object.assign(this, partial);
  }
}
