import { Entity, PrimaryGeneratedColumn, Column, Unique } from 'typeorm';
import { CommonStatus } from '../enum/common-status.enum';

@Entity('lookup_data')
@Unique(['lookupCategory', 'lookupKey'])
export class LookupData {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({
    name: 'lookup_category',
    type: 'varchar',
    length: 255,
    nullable: false,
  })
  lookupCategory: string;

  @Column({
    name: 'lookup_category_name',
    type: 'varchar',
    length: 255,
    nullable: true,
  })
  lookupCategoryName: string;

  @Column({
    name: 'lookup_key',
    type: 'varchar',
    length: 255,
    nullable: false,
  })
  lookupKey: string;

  @Column({
    name: 'lookup_label',
    type: 'varchar',
    length: 255,
    nullable: false,
  })
  lookupLabel: string;

  @Column({
    name: 'lookup_status',
    type: 'enum',
    enum: CommonStatus,
    enumName: 'hdb_common_status_enum',
    default: CommonStatus.ACTIVE,
  })
  lookupStatus: CommonStatus;
}
