// import and export all entities from the common/entities directory
import { Option } from './option.entity';
import { OptionCategory } from './option-category.entity';
import { User } from './user.entity';
import { Question } from './question.entity';
import { QuestionOptionMap } from './question-option.entity';
import { FormSection } from './form-section.entity';
import { Program } from './program.entity';
import { ProgramType } from './program-type.entity';
import { ProgramQuestion } from './program-question.entity';
import { ProgramSession } from './program-session.entity';
import { ProgramRegistration } from './program-registration.entity';
import { RegistrationApproval } from './registration-approval.entity';
import { RegistrationCustomResponse } from './registration-custom-response.entity';
import { RegistrationQuestionAnswer } from './registration-question-answer.entity';
import { RegistrationInvoiceDetail } from './registration-invoice-detail.entity';
import { RegistrationPaymentDetail } from './registration-payment-detail.entity';
import { RegistrationTravelInfo } from './registration-travel-info.entity';
import { RegistrationTravelPlan } from './registration-travel-plan.entity';
import { ProgramRegistrationFailure } from './program-registration-failure.entity';
import { UserRole } from './user-role.entity';
import { UserRoleMap } from './user-role-map.entity';
import { RegistrationPaymentDetailsHistory } from './registration-payment-details-history.entity';
import { CommunicationTrack } from './communication-track.entity';
import { Message } from './program-message.entity';
import { Preference } from './preference.entity';
import { ProgramRegistrationRmRatingType } from './program-registration-rm-rating-type.entity';
import { ProgramRegistrationRmRating } from './program-registration-rm-rating.entity';
import { ProgramRegistrationSwap } from './program-registration-swap.entity';
import { Address } from './address.entity';
import { LookupData } from './lookup-data.entity';
import { UserSession } from './user-session.entity';
import { RegistrationApprovalTrack } from './approval-track.entity';
import { FeatureFlag } from './feature-flag.entity';

export * from './option.entity';
export * from './option-category.entity';
export * from './user.entity';
export * from './question.entity';
export * from './question-option.entity';
export * from './program.entity';
export * from './program-type.entity';
export * from './form-section.entity';
export * from './program-question.entity';
export * from './program-session.entity';
export * from './program-registration.entity';
export * from './registration-approval.entity';
export * from './registration-custom-response.entity';
export * from './registration-question-answer.entity';
export * from './registration-invoice-detail.entity';
export * from './registration-payment-detail.entity';
export * from './registration-travel-info.entity';
export * from './registration-travel-plan.entity';
export * from './program-registration-failure.entity';
export * from './user-role.entity';
export * from './user-role-map.entity';
export * from './registration-payment-details-history.entity';
export * from './communication-track.entity';
export * from './preference.entity';
export * from './program-registration-rm-rating-type.entity';
export * from './program-registration-rm-rating.entity';
export * from './program-registration-swap.entity';
export * from './address.entity';
export * from './program-message.entity';
export * from './lookup-data.entity';
export * from './user-session.entity';
export * from './approval-track.entity';
export * from './feature-flag.entity';

export const entities = [
  Option,
  OptionCategory,
  User,
  Question,
  QuestionOptionMap,
  Program,
  ProgramType,
  FormSection,
  ProgramQuestion,
  ProgramSession,
  ProgramRegistration,
  RegistrationApproval,
  RegistrationCustomResponse,
  RegistrationQuestionAnswer,
  RegistrationInvoiceDetail,
  RegistrationPaymentDetail,
  RegistrationTravelInfo,
  RegistrationTravelPlan,
  ProgramRegistrationFailure,
  UserRole,
  UserRoleMap,
  CommunicationTrack,
  Preference,
  RegistrationPaymentDetailsHistory,
  ProgramRegistrationRmRatingType,
  ProgramRegistrationRmRating,
  ProgramRegistrationSwap,
  Address,
  Message,
  LookupData,
  UserSession,
  RegistrationApprovalTrack,
  FeatureFlag,
];
