export const ERROR_CODES = {
  QUESTION_CREATOR_NOTFOUND: 'Q_NF_001',
  QUESTION_UPDATOR_NOTFOUND: 'Q_NF_002',
  QUESTION_NOTFOUND: 'Q_NF_003',
  QUESTION_NOTFOUND_OR_UNPUBLISHED: 'Q_NF_004',
  QUESTION_DUPLICATE_BADREQUEST: 'Q_BR_001',
  QUESTION_FIND_BY_ID_FAILED: 'Q_FIND_BY_ID_FAILED',
  QUESTION_FIND_BY_LABEL_TYPE_FAILED: 'Q_FIND_BY_LABEL_TYPE_FAILED',
  QUESTION_SAVE_FAILED: 'Q_SAVE_FAILED',
  QUESTION_DELETE_FAILED: 'Q_DELETE_FAILED',
  QUESTION_COUNT_FAILED: 'Q_COUNT_FAILED',
  QUESTION_ID_REQUIRED: 'Q_ID_REQUIRED',
  QUESTION_BY_PROGRAM_ID_FAILED: 'Q_BY_PROGRAM_ID_FAILED',
  COMMON_DATA_SERVICE_GET_FAILED: 'CDS_GET_FAILED',
  COMMON_DATA_SERVICE_FINDBYID_FAILED: 'CDS_FIND_BY_ID_FAILED',
  COMMON_DATA_SERVICE_SAVE_FAILED: 'CDS_SAVE_FAILED',
  COMMON_DATA_SERVICE_FINDBYDATA_FAILED: 'CDS_UPDATE_FAILED',
  OPTION_CATEGORY_NOTFOUND: 'OC_NF_001',
  OPTION_CATEGORY_UPDATOR_NOTFOUND: 'OC_NF_002',
  OPTION_CATEGORY_DUPLICATE_BADREQUEST: 'OC_BR_001',
  OPTION_CATEGORY_FIND_BY_ID_FAILED: 'OC_FIND_BY_ID_FAILED',
  OPTION_CATEGORY_SAVE_FAILED: 'OC_SAVE_FAILED',
  OPTION_CATEGORY_DELETE_FAILED: 'OC_DELETE_FAILED',
  OPTION_CATEGORY_COUNT_FAILED: 'OC_COUNT_FAILED',
  OPTION_CATEGORY_GET_FAILED: 'OC_GET_FAILED',
  OPTION_CREATOR_NOTFOUND: 'O_NF_001',
  OPTION_UPDATOR_NOTFOUND: 'O_NF_002',
  OPTION_NOTFOUND: 'O_NF_003',
  OPTION_DUPLICATE_BADREQUEST: 'O_BR_001',
  OPTION_FIND_BY_ID_FAILED: 'O_FIND_BY_ID_FAILED',
  OPTION_FIND_BY_LABEL_TYPE_FAILED: 'O_FIND_BY_LABEL_TYPE_FAILED',
  OPTION_SAVE_FAILED: 'O_SAVE_FAILED',
  OPTION_DELETE_FAILED: 'O_DELETE_FAILED',
  OPTION_COUNT_FAILED: 'O_COUNT_FAILED',
  OPTION_GET_FAILED: 'O_GET_FAILED',
  USER_NOTFOUND: 'U_NF_001',
  USER_NOTFOUND_BY_CONCAT_FIELDS: 'U_NF_002',
  USER_EMAIL_ALREADY_EXISTS: 'U_BR_001',
  USER_PHONE_UPDATE_NOT_ALLOWED: 'U_BR_002',
  // question-option mapping
  QUESTION_OPTION_NOTFOUND: 'QO_NF_001',
  QUESTION_OPTION_CREATOR_NOTFOUND: 'QO_NF_002',
  QUESTION_OPTION_UPDATOR_NOTFOUND: 'QO_NF_003',
  QUESTION_OPTION_DUPLICATE_BADREQUEST: 'QO_BR_001',
  QUESTION_OPTION_FIND_BY_ID_FAILED: 'QO_FIND_BY_ID_FAILED',
  QUESTION_OPTION_FIND_ALL_FAILED: 'QO_FIND_ALL_FAILED',
  QUESTION_OPTION_SAVE_FAILED: 'QO_SAVE_FAILED',
  QUESTION_OPTION_UPDATE_FAILED: 'QO_UPDATE_FAILED',
  QUESTION_OPTION_DELETE_FAILED: 'QO_DELETE_FAILED',
  QUESTION_OPTION_GET_FAILED: 'QO_GET_FAILED',
  QUESTION_OPTION_CREATION_FAILED: 'QO_CREATION_FAILED',
  //program
  PROGRAM_CREATOR_NOTFOUND: 'P_NF_001',
  PROGRAM_UPDATOR_NOTFOUND: 'P_NF_002',
  PROGRAM_NOTFOUND: 'P_NF_003',
  PROGRAM_DUPLICATE_BADREQUEST: 'PROGRAM_DUPLICATE_BADREQUEST',
  PROGRAM_FIND_BY_ID_FAILED: 'PROGRAM_FIND_BY_ID_FAILED',
  PROGRAM_SAVE_FAILED: 'PROGRAM_SAVE_FAILED',
  PROGRAM_DELETE_FAILED: 'PROGRAM_DELETE_FAILED',
  PROGRAM_GET_FAILED: 'PROGRAM_GET_FAILED',
  PROGRAM_COUNT_FAILED: 'PROGRAM_COUNT_FAILED',
  PROGRAM_FEE_NOTFOUND: 'PROGRAM_FEE_NOTFOUND',
  //program type
  PROGRAM_TYPE_NOTFOUND: 'PT_NF_001',
  PROGRAM_TYPE_CREATOR_NOTFOUND: 'PT_NF_002',
  PROGRAM_TYPE_UPDATOR_NOTFOUND: 'PT_NF_003',
  PROGRAM_TYPE_GET_FAILED: 'PT_GET_FAILED',
  PROGRAM_TYPE_FIND_BY_ID_FAILED: 'PT_FIND_BY_ID_FAILED',
  PROGRAM_TYPE_COUNT_FAILED: 'PT_COUNT_FAILED',
  PROGRAM_TYPE_SAVE_FAILED: 'PT_SAVE_FAILED',
  PT_SAVE_FAILED: 'PT_SAVE_FAILED',
  PROGRAM_TYPE_DELETE_FAILED: 'PT_DELETE_FAILED',
  PROGRAM_TYPE_FIND_BY_NAME_FAILED: 'PT_FIND_BY_NAME_FAILED',
  PROGRAM_TYPE_DUPLICATE_BADREQUEST: 'PT_BR_001',

  // Form Section
  FORM_SECTION_CREATOR_NOTFOUND: 'FS_NF_001',
  FORM_SECTION_UPDATOR_NOTFOUND: 'FS_NF_002',
  FORM_SECTION_NOTFOUND: 'FS_NF_003',
  FORM_SECTION_DUPLICATE_BADREQUEST: 'FS_BR_001',
  FORM_SECTION_FIND_FAILED: 'FS_FIND_FAILED',
  FORM_SECTION_SAVE_FAILED: 'FS_SAVE_FAILED',
  FORM_SECTION_UPDATE_FAILED: 'FS_UPDATE_FAILED',
  FORM_SECTION_DELETE_FAILED: 'FS_DELETE_FAILED',
  FORM_SECTION_GET_FAILED: 'FS_GET_FAILED',
  FORM_SECTION_COUNT_FAILED: 'FS_COUNT_FAILED',
  FORM_SECTION_EXISTING_MAPPING_CHECK_FAILED: 'FS_EXISTING_MAPPING_CHECK_FAILED',
  FORM_SECTION_SCOPE_VALIDATION_FAILED: 'FS_SCOPE_VALIDATION_FAILED',
  FORM_SECTION_CUSTOM_QUESTION_CREATION_FAILED: 'FS_CUSTOM_QUESTION_CREATION_FAILED',
  FORM_SECTION_OPTION_MAPPING_FAILED: 'FS_OPTION_MAPPING_FAILED',

  // Program Question
  PROGRAM_QUESTION_NOTFOUND: 'PQ_NF_001',
  PROGRAM_QUESTION_CREATOR_NOTFOUND: 'PQ_NF_002',
  PROGRAM_QUESTION_UPDATOR_NOTFOUND: 'PQ_NF_003',
  PROGRAM_QUESTION_DUPLICATE_BADREQUEST: 'PQ_BR_001',
  PROGRAM_SESSION_REQUIRED_FOR_SESSION_LEVEL: 'PQ_BR_002',
  PROGRAM_SESSION_MISMATCH: 'PQ_BR_003',
  PROGRAM_QUESTION_FIND_BY_ID_FAILED: 'PQ_FIND_BY_ID_FAILED',
  PROGRAM_QUESTION_FIND_ALL_FAILED: 'PQ_FIND_ALL_FAILED',
  PROGRAM_QUESTION_SAVE_FAILED: 'PQ_SAVE_FAILED',
  PROGRAM_QUESTION_UPDATE_FAILED: 'PQ_UPDATE_FAILED',
  PROGRAM_QUESTION_DELETE_FAILED: 'PQ_DELETE_FAILED',
  PROGRAM_QUESTION_GET_FAILED: 'PQ_GET_FAILED',
  PROGRAM_QUESTION_CREATION_FAILED: 'PQ_CREATION_FAILED',
  PROGRAM_QUESTION_FETCH_FAILED: 'PQ_FETCH_FAILED',
  PROGRAM_QUESTION_TRANSACTION_FAILED: 'PQ_TRANSACTION_FAILED',
  PROGRAM_QUESTION_VALIDATION_FAILED: 'PQ_VALIDATION_FAILED',
  PROGRAM_QUESTION_BULK_UPDATE_FAILED: 'PQ_BULK_UPDATE_FAILED',
  PROGRAM_QUESTION_BULK_DELETE_FAILED: 'PQ_BULK_DELETE_FAILED',
  PROGRAM_QUESTION_SECTION_DELETE_FAILED: 'PQ_SECTION_DELETE_FAILED',
  PROGRAM_QUESTION_EXISTING_MAPPING_CHECK_FAILED: 'PQ_EXISTING_MAPPING_CHECK_FAILED',
  PROGRAM_QUESTION_SCOPE_VALIDATION_FAILED: 'PQ_SCOPE_VALIDATION_FAILED',
  PROGRAM_QUESTION_CUSTOM_QUESTION_CREATION_FAILED: 'PQ_CUSTOM_QUESTION_CREATION_FAILED',
  PROGRAM_QUESTION_OPTION_MAPPING_FAILED: 'PQ_OPTION_MAPPING_FAILED',

  // Form Schema Service
  FORM_SCHEMA_GENERATION_FAILED: 'FORM_SCHEMA_001',
  FORM_SCHEMA_PROCESSING_FAILED: 'FORM_SCHEMA_002',
  QUESTION_CREATION_FAILED: 'FORM_SCHEMA_003',
  PROGRAM_METADATA_REQUIRED: 'FORM_SCHEMA_004',
  PROGRAM_METADATA_NOT_FOUND: 'FORM_SCHEMA_005',
  PROGRAM_METADATA_INVALID: 'FORM_SCHEMA_006',

  PROGRAM_SESSION_CREATOR_NOTFOUND: 'PS_NF_001',
  PROGRAM_SESSION_UPDATOR_NOTFOUND: 'PS_NF_002',
  PROGRAM_SESSION_NOTFOUND: 'PS_NF_003',
  PROGRAM_SESSION_DUPLICATE_BADREQUEST: 'PS_BR_001',
  PROGRAM_SESSION_FIND_BY_ID_FAILED: 'PS_FIND_BY_ID_FAILED',
  PROGRAM_SESSION_SAVE_FAILED: 'PS_SAVE_FAILED',
  PROGRAM_SESSION_DELETE_FAILED: 'PS_DELETE_FAILED',
  PROGRAM_SESSION_GET_FAILED: 'PS_GET_FAILED',
  PROGRAM_SESSION_COUNT_FAILED: 'PS_COUNT_FAILED',
  // Program Registration
  PROGRAM_REGISTRATION_NOTFOUND: 'PR_NF_001',
  PROGRAM_REGISTRATION_SAVE_FAILED: 'PR_SAVE_FAILED',
  PROGRAM_REGISTRATION_DELETE_FAILED: 'PR_DELETE_FAILED',
  PROGRAM_REGISTRATION_GET_FAILED: 'PR_GET_FAILED',
  PROGRAM_REGISTRATION_FIND_BY_ID_FAILED: 'PR_FIND_BY_ID_FAILED',
  INVALID_PROGRAM_SESSION: 'PR_INVALID_SESSION',
  PROGRAM_REGISTRATION_RM_RATING_SAVE_FAILED: 'PR_RM_RATING_SAVE_FAILED',
  PROGRAM_REGISTRATION_RM_RATING_FAILED: 'PR_RM_RATING_FAILED',
  PROGRAM_REGISTRATION_RM_RATING_NOT_FOUND: 'PR_RM_RATING_NOT_FOUND',
  PROGRAM_REGISTRATION_RM_RATING_UPDATE_FAILED: 'PR_RM_RATING_UPDATE_FAILED',
  PROGRAM_SWAP_REQUEST_UPDATE_FAILED: 'PROGRAM_SWAP_REQUEST_UPDATE_FAILED',
  PROGRAM_SWAP_REQUEST_NOT_FOUND: 'PROGRAM_SWAP_REQUEST_NOT_FOUND',
  PROGRAM_SWAP_REQUEST_GET_FAILED: 'PROGRAM_SWAP_REQUEST_GET_FAILED',
  SWAP_REQUEST_ALREADY_UPDATED: 'SWAP_REQUEST_ALREADY_UPDATED',
  PROGRAM_NOT_FOUND: 'PROGRAM_NOT_FOUND',
  SEATS_ALREADY_FULL: 'SEATS_ALREADY_FULL',
  NO_FILLED_SEATS: 'NO_FILLED_SEATS',
  PROGRAM_REGISTRATION_NOT_FOUND: 'PROGRAM_REGISTRATION_NOT_FOUND',
  TARGET_PROGRAM_NOT_FOUND: 'TARGET_PROGRAM_NOT_FOUND',
  SWAP_REQUEST_ALREADY_EXISTS: 'SWAP_REQUEST_ALREADY_EXISTS',
  INVALID_SWAP_REQUEST_STATUS: 'INVALID_SWAP_REQUEST_STATUS',

  // Registration Approval
  REGISTRATION_APPROVAL_NOTFOUND: 'RA_NF_001',
  REGISTRATION_APPROVAL_SAVE_FAILED: 'RA_SAVE_FAILED',
  REGISTRATION_APPROVAL_DELETE_FAILED: 'RA_DELETE_FAILED',
  REGISTRATION_APPROVAL_GET_FAILED: 'RA_GET_FAILED',
  REGISTRATION_APPROVAL_FIND_BY_ID_FAILED: 'RA_FIND_BY_ID_FAILED',
  REGISTRATION_APPROVAL_ALREADY_EXISTS: 'RA_ALREADY_EXISTS',

  // Registration Custom Response
  REGISTRATION_CUSTOM_RESPONSE_NOTFOUND: 'RCR_NF_001',
  REGISTRATION_CUSTOM_RESPONSE_SAVE_FAILED: 'RCR_SAVE_FAILED',
  REGISTRATION_CUSTOM_RESPONSE_DELETE_FAILED: 'RCR_DELETE_FAILED',
  REGISTRATION_CUSTOM_RESPONSE_GET_FAILED: 'RCR_GET_FAILED',
  REGISTRATION_CUSTOM_RESPONSE_FIND_BY_ID_FAILED: 'RCR_FIND_BY_ID_FAILED',

  // Registration Invoice Detail
  REGISTRATION_INVOICE_DETAIL_NOTFOUND: 'RID_NF_001',
  REGISTRATION_INVOICE_DETAIL_SAVE_FAILED: 'RID_SAVE_FAILED',
  REGISTRATION_INVOICE_DETAIL_DELETE_FAILED: 'RID_DELETE_FAILED',
  REGISTRATION_INVOICE_DETAIL_GET_FAILED: 'RID_GET_FAILED',
  REGISTRATION_INVOICE_DETAIL_FIND_BY_ID_FAILED: 'RID_FIND_BY_ID_FAILED',

  // Registration Payment Detail
  REGISTRATION_PAYMENT_DETAIL_NOTFOUND: 'RPD_NF_001',
  REGISTRATION_PAYMENT_DETAIL_SAVE_FAILED: 'RPD_SAVE_FAILED',
  REGISTRATION_PAYMENT_DETAIL_DELETE_FAILED: 'RPD_DELETE_FAILED',
  REGISTRATION_PAYMENT_DETAIL_GET_FAILED: 'RPD_GET_FAILED',
  REGISTRATION_PAYMENT_DETAIL_FIND_BY_ID_FAILED: 'RPD_FIND_BY_ID_FAILED',

  // Registration Travel Info
  REGISTRATION_TRAVEL_INFO_NOTFOUND: 'RTI_NF_001',
  REGISTRATION_TRAVEL_INFO_SAVE_FAILED: 'RTI_SAVE_FAILED',
  REGISTRATION_TRAVEL_INFO_DELETE_FAILED: 'RTI_DELETE_FAILED',
  REGISTRATION_TRAVEL_INFO_GET_FAILED: 'RTI_GET_FAILED',
  REGISTRATION_TRAVEL_INFO_FIND_BY_ID_FAILED: 'RTI_FIND_BY_ID_FAILED',

  // Registration Travel Plan
  REGISTRATION_TRAVEL_PLAN_NOTFOUND: 'RTP_NF_001',
  REGISTRATION_TRAVEL_PLAN_SAVE_FAILED: 'RTP_SAVE_FAILED',
  REGISTRATION_TRAVEL_PLAN_DELETE_FAILED: 'RTP_DELETE_FAILED',
  REGISTRATION_TRAVEL_PLAN_GET_FAILED: 'RTP_GET_FAILED',
  REGISTRATION_TRAVEL_PLAN_FIND_BY_ID_FAILED: 'RTP_FIND_BY_ID_FAILED',

  // Registration
  REGISTRATION_GET_FAILED: 'REG_GET_FAILED',
  REGISTRATION_FIND_BY_ID_FAILED: 'REG_FIND_BY_ID_FAILED',
  REGISTRATION_INVALID_QUESTION: 'R_BR_001',
  REGISTRATION_INVALID_STATUS: 'R_BR_002',
  REGISTRATION_PENDING_APPROVAL: 'R_BR_003',
  REGISTRATION_ALREADY_APPROVED: 'R_BR_004',
  REGISTRATION_CREATION_FAILED: 'R_SAVE_FAILED',
  REGISTRATION_NO_SPACE: 'R_NO_SPACE',
  REGISTRATION_FAILURE_SAVE_FAILED: 'RF_SAVE_FAILED',
  USER_ALREADY_REGISTERED: 'USER_ALREADY_REGISTERED',
  REGISTRATION_ALREADY_EXISTS: 'REGISTRATION_ALREADY_EXISTS',
  REGISTRATION_QUESTION_RESPONSE_GET_FAILED: 'R_QR_GET_FAILED',
  REGISTRATION_NOT_FOUND: 'RE_NF_001',
  REGISTRATION_ALREADY_CANCELLED: 'RE_ALREADY_CANCELLED',
  REGISTRATION_CANCEL_FAILED: 'RE_CANCEL_FAILED',
  REGISTRATION_ID_REQUIRED: 'RE_ID_REQUIRED',

  // User
  USER_GET_ALL_FAILED: 'USER_GET_ALL_FAILED',
  USER_NOT_FOUND_BY_ROLE:'USER_NOT_FOUND_BY_ROLE',

  // Invoice
  INVOICE_GENERATION_FAILED: 'INVOICE_GENERATION_FAILED',
  INVOICE_NOTFOUND: 'INVOICE_NF_001',
  EINVOICE_GENERATION_FAILED: 'EINVOICE_GENERATION_FAILED',

  //Payments
  PAYMENT_ALREADY_EXISTS: 'PAYMENT_ALREADY_EXISTS',
  PAYMENT_INITIATION_FAILED: 'PAYMENT_INITIATION_FAILED',
  PAYMENT_UPDATE_FAILED: 'PAYMENT_UPDATE_FAILED',
  PAYMENT_NOTFOUND: 'INVOICE_NF_001',
  PAYMENT_GET_FAILED: 'PAYMENT_GET_FAILED',
  PAYMENT_CREATION_FAILED: 'PAYMENT_CREATION_FAILED',
  PAYMENT_CONFIRMATION_FAILED: 'PAYMENT_CONFIRMATION_FAILED',
  TDS_AMOUNT_INVALID: 'TDS_AMOUNT_INVALID',
  TDS_AMOUNT_EXCEEDS: 'TDS_AMOUNT_EXCEEDS',
  PAYMENT_ALREADY_COMPLETED: 'PAYMENT_ALREADY_COMPLETED',

  //webhook
  INVALID_WEBHOOK_SIGNATURE: 'INVALID_WEBHOOK_SIGNATURE',
  WEBHOOK_PROCESSING_FAILED: 'WEBHOOK_PROCESSING_FAILED',
  INVALID_WEBHOOK_DATA: 'INVALID_WEBHOOK_DATA',

  // General
  INTERNAL_SERVER_ERROR: 'INTERNAL_SERVER_ERROR',

  // Program Question
  PQ_ID_REQUIRED: 'PQ_ID_REQUIRED',
  PQ_BULK_DELETE_FAILED: 'PQ_BULK_DELETE_FAILED',
  PQ_SECTION_DELETE_FAILED: 'PQ_SECTION_DELETE_FAILED',
  PQ_EXISTING_MAPPING_CHECK_FAILED: 'PQ_EXISTING_MAPPING_CHECK_FAILED',
  PQ_SCOPE_VALIDATION_FAILED: 'PQ_SCOPE_VALIDATION_FAILED',
  PQ_CUSTOM_QUESTION_CREATION_FAILED: 'PQ_CUSTOM_QUESTION_CREATION_FAILED',
  PQ_OPTION_MAPPING_FAILED: 'PQ_OPTION_MAPPING_FAILED',
  PQ_TRANSACTION_FAILED: 'PQ_TRANSACTION_FAILED',
  PQ_VALIDATION_FAILED: 'PQ_VALIDATION_FAILED',

  // Form Section
  FS_ID_REQUIRED: 'FS_ID_REQUIRED',
  FS_EXISTING_MAPPING_CHECK_FAILED: 'FS_EXISTING_MAPPING_CHECK_FAILED',
  FS_SCOPE_VALIDATION_FAILED: 'FS_SCOPE_VALIDATION_FAILED',
  FS_CUSTOM_QUESTION_CREATION_FAILED: 'FS_CUSTOM_QUESTION_CREATION_FAILED',
  FS_OPTION_MAPPING_FAILED: 'FS_OPTION_MAPPING_FAILED',

  // Registration
  REG_ID_REQUIRED: 'REG_ID_REQUIRED',

  PREFERENCE_SAVE_FAILED: 'PREF_SAVE_FAILED',
  PREFERENCE_DELETE_FAILED: 'PREF_DELETE_FAILED',
  PREFERENCE_GET_FAILED: 'PREF_GET_FAILED',
  PREFERENCE_NOTFOUND: 'PREF_NF_001',
  PREFERENCE_CREATOR_NOTFOUND: 'PREF_NF_002',
  PREFERENCE_UPDATOR_NOTFOUND: 'PREF_NF_003',
  PREFERENCE_DUPLICATE_BADREQUEST: 'PREF_BR_001',
  PREFERENCE_FIND_BY_ID_FAILED: 'PREF_FIND_BY_ID_FAILED',
  PREFERENCE_FIND_BY_REGISTRATION_ID_FAILED: 'PREF_FIND_BY_REGISTRATION_ID_FAILED',
  PREFERENCE_PRIORITY_ORDER_NOT_UNIQUE: 'PREF_PRIORITY_ORDER_NOT_UNIQUE',
  PREFERENCE_ALREADY_EXISTS: 'PREF_ALREADY_EXISTS',

  // Communication
  FAILED_TO_SEND_EMAIL: 'FAILED_TO_SEND_EMAIL',
  FAILED_TO_SEND_BULK_EMAIL: 'FAILED_TO_SEND_BULK_EMAIL',
  FAILED_TO_HANDLE_EMAIL_WEBHOOK: 'FAILED_TO_HANDLE_EMAIL_WEBHOOK',
  FAILED_TO_SEND_WHATSAPP_MESSAGE: 'FAILED_TO_SEND_WHATSAPP_MESSAGE',
  FAILED_TO_SEND_BULK_WHATSAPP_MESSAGE: 'FAILED_TO_SEND_BULK_WHATSAPP_MESSAGE',
  FAILED_TO_HANDLE_WHATSAPP_WEBHOOK: 'FAILED_TO_HANDLE_WHATSAPP_WEBHOOK',

  // Communication Track
  COMMUNICATION_TRACK_SAVE_FAILED: 'COMMUNICATION_TRACK_SAVE_FAILED',
  COMMUNICATION_TRACK_GET_FAILED: 'COMMUNICATION_TRACK_GET_FAILED',
  COMMUNICATION_TRACK_NOTFOUND: 'COMMUNICATION_TRACK_NOTFOUND',
  COMMUNICATION_TRACK_FIND_BY_ID_FAILED: 'COMMUNICATION_TRACK_FIND_BY_ID_FAILED',
  COMMUNICATION_TRACK_DELETE_FAILED: 'COMMUNICATION_TRACK_DELETE_FAILED',
  COMMUNICATION_TRACK_UPDATE_FAILED: 'COMMUNICATION_TRACK_UPDATE_FAILED',

  // Dashboard
  PROGRAM_DASHBOARD_DATA_GET_FAILED:'PROGRAM_DASHBOARD_DATA_GET_FAILED',
  MESSAGE_SAVE_FAILED: 'MESSAGE_SAVE_FAILED',
  MESSAGE_GET_FAILED: 'MESSAGE_GET_FAILED',
  MESSAGE_INVALID_SENDER: 'MESSAGE_INVALID_SENDER',
  MESSAGE_INVALID_RECEIVER: 'MESSAGE_INVALID_RECEIVER',
  // Seat Management
  SEAT_COUNT_UPDATE_FAILED: 'SEAT_COUNT_UPDATE_FAILED',
  SEAT_COUNT_GET_FAILED: 'SEAT_COUNT_GET_FAILED',
  SEAT_COUNT_NOTFOUND: 'SEAT_COUNT_NOTFOUND',
  SEAT_COUNT_FIND_BY_ID_FAILED: 'SEAT_COUNT_FIND_BY_ID_FAILED',

  REGISTRATION_NOT_STARTED: 'REGISTRATION_NOT_STARTED',
  REGISTRATION_CLOSED: 'REGISTRATION_CLOSED',

  //prorgram validation
  DUPLICATE_DISPLAY_ORDER: 'DUPLICATE_DISPLAY_ORDER',
  INVALID_CHILD_DISPLAY_ORDER: 'INVALID_CHILD_DISPLAY_ORDER',
  INVALID_PRIMARY_DISPLAY_ORDER: 'INVALID_PRIMARY_DISPLAY_ORDER',
  CANNOT_CHANGE_TO_NON_GROUPED_TYPE: 'CANNOT_CHANGE_TO_NON_GROUPED_TYPE',
  GROUP_ID_MISMATCH: 'GROUP_ID_MISMATCH',
  INVALID_PRIMARY_PROGRAM: 'INVALID_PRIMARY_PROGRAM',
  PRIMARY_PROGRAM_NOT_FOUND: 'PRIMARY_PROGRAM_NOT_FOUND',
  INVALID_GROUP_CONFIGURATION: 'INVALID_GROUP_CONFIGURATION',
  INVALID_ADDRESS_TYPE: 'INVALID_ADDRESS_TYPE',
  INVALID_PINCODE: 'INVALID_PINCODE',
  PROGRAM_TYPE_DOES_NOT_SUPPORT_GROUPING: 'PROGRAM_TYPE_DOES_NOT_SUPPORT_GROUPING',
  CANNOT_UPDATE_GROUPED_PROGRAMS_ON_NON_PRIMARY: 'CANNOT_UPDATE_GROUPED_PROGRAMS_ON_NON_PRIMARY',
  DUPLICATE_GROUP_DISPLAY_ORDER: 'DUPLICATE_GROUP_DISPLAY_ORDER',
  INVALID_GROUP_DISPLAY_ORDER: 'INVALID_GROUP_DISPLAY_ORDER',
  DUPLICATE_PROGRAM_NAMES_IN_GROUP: 'DUPLICATE_PROGRAM_NAMES_IN_GROUP',
  DUPLICATE_PROGRAM_CODES_IN_GROUP: 'DUPLICATE_PROGRAM_CODES_IN_GROUP',
  INVALID_DATE_RANGE: 'INVALID_DATE_RANGE',
  INVALID_REGISTRATION_DATE_RANGE: 'INVALID_REGISTRATION_DATE_RANGE',
  INVALID_SEAT_CONFIGURATION: 'INVALID_SEAT_CONFIGURATION',
  INVALID_TIME_RANGE: 'INVALID_TIME_RANGE',
  INVALID_CHECKIN_CHECKOUT_DATE_RANGE: 'INVALID_CHECKIN_CHECKOUT_DATE_RANGE',
  INVALID_SEAT_COUNT: 'INVALID_SEAT_COUNT',
  INVALID_PROGRAM_HIERARCHY: 'INVALID_PROGRAM_HIERARCHY',

  // AI Communication
  FAILED_TO_ANALYZE: 'FAILED_TO_ANALYZE',
  FAILED_TO_VERIFY_FLIGHT_TICKET: 'FAILED_TO_VERIFY_FLIGHT_TICKET',
  FAILED_TO_EXTRACT_FLIGHT_DATA: 'FAILED_TO_EXTRACT_FLIGHT_DATA',
  DUPLICATE_IDS_IN_REQUEST: 'DUPLICATE_IDS_IN_REQUEST',
  INVALID_PROGRAM_IDS: 'INVALID_PROGRAM_IDS',
  // Deletion-related errors
  INVALID_DELETION_REQUEST: 'INVALID_DELETION_REQUEST',
  DUPLICATE_IDS_IN_DELETION_REQUEST: 'DUPLICATE_IDS_IN_DELETION_REQUEST', 
  INVALID_DELETED_PROGRAM_IDS: 'INVALID_DELETED_PROGRAM_IDS',
  CANNOT_DELETE_PRIMARY_PROGRAM: 'CANNOT_DELETE_PRIMARY_PROGRAM',
  CONFLICTING_PROGRAM_IDS: 'CONFLICTING_PROGRAM_IDS',
  LOOKUP_DATA_GET_FAILED: 'LOOKUP_DATA_GET_FAILED',
  
  // File Upload
  FAILED_TO_GENERATE_FILE_URLS: 'FAILED_TO_GENERATE_FILE_URLS',
  FILE_UPLOAD_FAILED: 'FILE_UPLOAD_FAILED',
  FAILED_TO_GENERATE_UPLOAD_URLS: 'FAILED_TO_GENERATE_UPLOAD_URLS',

  REGISTRATION_TRAVEL_PLAN_UPDATE_FAILED: 'RTP_UPDATE_FAILED',
  REGISTRATION_TRAVEL_PLAN_CREATE_FAILED: 'RTP_CREATE_FAILED',
  REGISTRATION_TRAVEL_INFO_UPDATE_FAILED: 'RTI_UPDATE_FAILED',
  REGISTRATION_TRAVEL_INFO_CREATE_FAILED: 'RTI_CREATE_FAILED',
  REGISTRATION_STATUS_UPDATE_FAILED: 'REG_STATUS_UPDATE_FAILED',

  USER_SESSION_SAVE_FAILED: 'US_SAVE_FAILED',
  USER_SESSION_UPDATE_FAILED: 'US_UPDATE_FAILED',
  USER_SESSION_NOTFOUND: 'US_NF_001',
  OTP_ATTEMPTS_EXCEEDED: 'US_ATTEMPTS',
  OTP_EXPIRED: 'US_EXPIRED',
  AUTH_INVALID_OTP: 'US_INVALID_OTP',
  USER_SAVE_FAILED: 'U_SAVE_FAILED',
  AUTH_INVALID_LOGIN_TYPE: 'AUTH_INVALID_LOGIN_TYPE',
  USER_UPDATE_FAILED: 'U_UPDATE_FAILED',
  USER_CREATION_FAILED: 'U_CREATION_FAILED',
  FEATURE_FLAG_GET_FAILED: 'FF_GET_FAILED',
};
