import { CanActivate, ExecutionContext, Injectable, UnauthorizedException } from '@nestjs/common';
import { AuthService } from './auth.service';

@Injectable()
export class OtpAuthGuard implements CanActivate {
  constructor(private readonly authService: AuthService) {}

  async canActivate(context: ExecutionContext): Promise<boolean> {
    const request = context.switchToHttp().getRequest();
    const token = request.headers.authorization?.split('Bearer ')[1]?.trim();
    if (!token) {
      throw new UnauthorizedException('Missing authentication token');
    }
    const session = await this.authService.validateJwt(token);
    if (!session || !session.user) {
      throw new UnauthorizedException('Invalid token');
    }
    const user = session.user;
    if (!Array.isArray(user.userRoleMaps)) {
      user.userRoleMaps = [] as any;
    }
    const hasValidRole = user.userRoleMaps.some(
      (urm) => urm.role && typeof urm.role.name === 'string' && urm.role.name.length > 0,
    );
    if (!hasValidRole) {
      user.userRoleMaps.push({
        role: {
          name: user.role || 'viewer',
          id: 0,
          roleKey: '',
          createdAt: new Date(),
          updatedAt: new Date(),
          userRoleMaps: [],
        },
        id: 0,
        user: user as any,
        createdAt: new Date(),
        updatedAt: new Date(),
      } as any);
    }
    request.user = {
      ...user,
      roles: user.userRoleMaps.map((u) => u.role?.name).filter(Boolean),
    };
    return true;
  }
}
