import { IsEnum, IsNotEmpty, IsOptional, IsEmail } from 'class-validator';
import { LoginTypeEnum } from 'src/common/enum/login-type.enum';

export class InitiateLoginDto {
  @IsEnum(LoginTypeEnum)
  loginType: LoginTypeEnum;

  @IsOptional()
  @IsNotEmpty()
  phoneNumber?: string;

  @IsOptional()
  @IsNotEmpty()
  countryCode?: string;

  @IsOptional()
  @IsEmail()
  email?: string;
}
