import { Global, MiddlewareConsumer, Module, NestModule } from '@nestjs/common';
import { AppController } from './app.controller';
import { AppService } from './app.service';
import { TypeOrmModule, TypeOrmModuleOptions } from '@nestjs/typeorm';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { dbConfig } from './common/config/config';
import { OptionModule } from './option/option.module';
import { OptionCategoryModule } from './option-category/option-category.module';
import { CommonDataService } from './common/services/commonData.service';
import { QuestionModule } from './question/question.module';
import { QuestionOptionModule } from './question-option/question-option.module';
import { AuthModule } from './auth/auth.module';
import { UserModule } from './user/user.module';
import { ResponseService } from './common/response-handling/response-handler';
import ErrorHandler from './common/response-handling/error-handling';
import { AppLoggerService } from './common/services/logger.service';
import { LoggerContextMiddleware } from './common/middleware/logger-context.middleware';
import { ProgramModule } from './program/program.module';
import { ProgramQuestionModule } from './program-question/program-question.module';
import { ProgramTypeModule } from './program-type/program-type.module';
import { FormSectionModule } from './form-section/form-section.module';
import { FormSchemaModule } from './form-schema/form-schema.module';
import { ProgramSessionModule } from './program-session/program-session.module';
import { ProgramRegistrationModule } from './program-registration/program-registration.module';
import { RegistrationApprovalModule } from './registration-approval/registration-approval.module';
import { RegistrationCustomResponseModule } from './registration-custom-response/registration-custom-response.module';
import { RegistrationInvoiceDetailModule } from './registration-invoice-detail/registration-invoice-detail.module';
import { RegistrationPaymentDetailModule } from './registration-payment-detail/registration-payment-detail.module';
import { RegistrationTravelInfoModule } from './registration-travel-info/registration-travel-info.module';
import { RegistrationTravelPlanModule } from './registration-travel-plan/registration-travel-plan.module';
import { RegistrationModule } from './registration/registration.module';
import { PaymentModule } from './payment/payment.module';
import { InvoiceModule } from './invoice/invoice.module';
import { PreferenceModule } from './preference/preference.module';
import { CommunicationModule } from './communication/communication.module';
import { AiCommunicationModule } from './ai-communication/ai-communication.module';
import { MessagesModule } from './messages/messages.module';
import { LookupDataModule } from './lookup-data/lookup-data.module';
import { AwsHandlingModule } from './aws-handling/aws-handling.module';
import { Msg91Service } from './common/services/msg91.service';

@Global()
@Module({
  imports: [
    TypeOrmModule.forRootAsync({
      imports: [ConfigModule],
      inject: [ConfigService],
      useFactory: async (configService: ConfigService): Promise<TypeOrmModuleOptions> =>
        dbConfig(configService),
    }),
    ConfigModule.forRoot({
      envFilePath: [`./environment/.env.${process.env.NODE_ENV || 'development'}`],
      isGlobal: true,
    }),
    OptionModule,
    OptionCategoryModule,
    QuestionModule,
    QuestionOptionModule,
    AuthModule,
    UserModule,
    ProgramModule,
    ProgramTypeModule,
    ProgramQuestionModule,
    FormSectionModule,
    FormSchemaModule,
    ProgramSessionModule,
    ProgramRegistrationModule,
    RegistrationApprovalModule,
    RegistrationCustomResponseModule,
    RegistrationInvoiceDetailModule,
    RegistrationPaymentDetailModule,
    RegistrationTravelInfoModule,
    RegistrationTravelPlanModule,
    RegistrationModule,
    PaymentModule,
    InvoiceModule,
    PreferenceModule,
    CommunicationModule,
    AiCommunicationModule,
    MessagesModule,
    LookupDataModule,
    AwsHandlingModule,
  ],
  controllers: [AppController],
  providers: [AppService, CommonDataService, ResponseService, ErrorHandler, AppLoggerService, Msg91Service],
  exports: [CommonDataService, ResponseService, ErrorHandler, AppLoggerService, Msg91Service],
})
export class AppModule implements NestModule {
  configure(consumer: MiddlewareConsumer) {
    consumer.apply(LoggerContextMiddleware).forRoutes('*');
  }
}
