import { ApiProperty } from '@nestjs/swagger';
import { IsEnum, IsString, IsUrl } from 'class-validator';
import { DocumentTypeEnum } from 'src/common/enum/document-type.enum';

// export class CreateAiCommunicationDto {}
export class ExtractionInfo {
  @ApiProperty({
    description: 'URL of the document to be processed',
    example: 'https://example.com/document.pdf',
    type: String,
  })
  @IsUrl({}, { message: 'Please provide a valid URL' })
  @IsString()
  url: string;

  @ApiProperty({
    description: 'Type of the document',
    example: 'flight_ticket',
    enum: DocumentTypeEnum,
  })
  @IsEnum(DocumentTypeEnum, {
    message: 'Document type must be one of: flight_ticket, identity_details',
  })
  type: DocumentTypeEnum;
}
