import { forwardRef, Module } from '@nestjs/common';
import { AiCommunicationService } from './ai-communication.service';
import { AiCommunicationController } from './ai-communication.controller';
import { HttpModule } from '@nestjs/axios';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { AppLoggerService } from 'src/common/services/logger.service';
import { ConfigModule } from '@nestjs/config';

@Module({
  imports: [forwardRef(() => AuthModule), forwardRef(() => UserModule), ConfigModule],
  controllers: [AiCommunicationController],
  providers: [AiCommunicationService, AppLoggerService],
  exports: [AiCommunicationService],
})
export class AiCommunicationModule {}
