CREATE TABLE hdb_program_registration_swap(
	id SERIAL PRIMARY KEY,
	program_registration_id BIGINT,
	type VARCHAR(255),
	status VARCHAR(255),
	comment TEXT
	created_at TIMESTAMP WITHOUT TIME ZONE,
	updated_at TIMESTAMP WITHOUT TIME ZONE,
	created_by BIGINT,
	updated_by BIGINT,
	target_program_id BIGINT,
	FOREIGN KEY (created_by) REFERENCES users(id),
	FOREIGN KEY (updated_by) REFERENCES users(id),
);

ALTER TABLE public.hdb_program_registration_swap
	ADD COLUMN allocated_program_id BIGINT,
	ADD COLUMN current_program_id BIGINT,
	ADD CONSTRAINT fk_current_program FOREIGN KEY (current_program_id)
    REFERENCES program_v1(id),
	ADD CONSTRAINT fk_allocated_program FOREIGN KEY (allocated_program_id)
    REFERENCES program_v1(id);


CREATE TABLE hdb_swap_requested_program(
	id SERIAL PRIMARY KEY,
	swap_request_id BIGINT,
	program_id BIGINT,
	created_at TIMESTAMP WITHOUT TIME ZONE,
	updated_at TIMESTAMP WITHOUT TIME ZONE,
	created_by BIGINT,
	updated_by BIGINT,
	FOREIGN KEY (swap_request_id) REFERENCES hdb_program_registration_swap(id),
	FOREIGN KEY (program_id) REFERENCES program_v1(id),
	FOREIGN KEY (created_by) REFERENCES users(id),
	FOREIGN KEY (updated_by) REFERENCES users(id)
)
