ALTER TABLE program_v1
  DROP COLUMN IF EXISTS checkin_date,
  DROP COLUMN IF EXISTS checkin_time,
  DROP COLUMN IF EXISTS checkout_date,
  DROP COLUMN IF EXISTS checkout_time,
  ADD COLUMN IF NOT EXISTS checkin_at TIMESTAMPTZ NULL,
  ADD COLUMN IF NOT EXISTS checkout_at TIMESTAMPTZ NULL,
  ADD COLUMN IF NOT EXISTS tds_percent DECIMAL(5,2) DEFAULT 0, -- Added
  ADD COLUMN IF NOT EXISTS gst_number VARCHAR(50);             -- Added

ALTER TABLE program_session
  DROP COLUMN IF EXISTS checkin_time,
  DROP COLUMN IF EXISTS checkout_time,
  ADD COLUMN IF NOT EXISTS checkin_at TIMESTAMPTZ NULL,
  ADD COLUMN IF NOT EXISTS checkout_at TIMESTAMPTZ NULL,
  ADD COLUMN IF NOT EXISTS tds_percent DECIMAL(5,2) DEFAULT 0, -- Added
  ADD COLUMN IF NOT EXISTS gst_number VARCHAR(50);             -- Added

-- program_v1 table changes
ALTER TABLE program_v1
  DROP COLUMN IF EXISTS registration_start_date,
  DROP COLUMN IF EXISTS registration_start_time,
  DROP COLUMN IF EXISTS registration_end_date,
  DROP COLUMN IF EXISTS registration_end_time,
  DROP COLUMN IF EXISTS checkin_date,
  DROP COLUMN IF EXISTS checkin_time,
  DROP COLUMN IF EXISTS checkout_date,
  DROP COLUMN IF EXISTS checkout_time,
  DROP COLUMN IF EXISTS start_date,
  DROP COLUMN IF EXISTS start_time,
  DROP COLUMN IF EXISTS end_date,
  DROP COLUMN IF EXISTS end_time,
  ADD COLUMN registration_starts_at TIMESTAMPTZ,
  ADD COLUMN registration_ends_at TIMESTAMPTZ,
  ADD COLUMN checkin_at TIMESTAMPTZ,
  ADD COLUMN checkout_at TIMESTAMPTZ,
  ADD COLUMN starts_at TIMESTAMPTZ,
  ADD COLUMN ends_at TIMESTAMPTZ;

-- program_session table changes
ALTER TABLE program_session
  DROP COLUMN IF EXISTS registration_start_date,
  DROP COLUMN IF EXISTS registration_start_time,
  DROP COLUMN IF EXISTS registration_end_date,
  DROP COLUMN IF EXISTS registration_end_time,
  DROP COLUMN IF EXISTS checkin_date,
  DROP COLUMN IF EXISTS checkin_time,
  DROP COLUMN IF EXISTS checkout_date,
  DROP COLUMN IF EXISTS checkout_time,
  DROP COLUMN IF EXISTS start_date,
  DROP COLUMN IF EXISTS start_time,
  DROP COLUMN IF EXISTS end_date,
  DROP COLUMN IF EXISTS end_time,
  ADD COLUMN registration_starts_at TIMESTAMPTZ,
  ADD COLUMN registration_ends_at TIMESTAMPTZ,
  ADD COLUMN checkin_at TIMESTAMPTZ,
  ADD COLUMN checkout_at TIMESTAMPTZ,
  ADD COLUMN starts_at TIMESTAMPTZ,
  ADD COLUMN ends_at TIMESTAMPTZ;

ALTER TABLE hdb_registration_travel_plan
  ADD COLUMN checkin_at TIMESTAMPTZ

ALTER TABLE hdb_registration_invoice_detail
  ADD COLUMN tds_amount numeric(10,2);


ALTER TABLE hdb_registration_invoice_detail
ADD COLUMN einvoice_qr_link VARCHAR(1024),
ADD COLUMN einvoice_ack_date VARCHAR(500),
ADD COLUMN einvoice_inv_ref_num VARCHAR(1024),
ADD COLUMN einvoice_is_cancellable BOOLEAN,
ADD COLUMN einvoice_status_formatted VARCHAR(1024),
ADD COLUMN einvoice_formatted_status VARCHAR(500),
ADD COLUMN einvoice_ack_number VARCHAR(500),
ADD COLUMN einvoice_status VARCHAR(500);

ALTER TABLE public.hdb_registration_invoice_detail
ADD COLUMN invoice_pdf_url VARCHAR(2048);