
ALTER TABLE public.program_session
ALTER COLUMN program_id SET NOT NULL;

ALTER TABLE public.program_session
ADD COLUMN start_date date,
ADD COLUMN start_time time with time zone,
ADD COLUMN end_date date,
ADD COLUMN end_time time with time zone,
ADD COLUMN registration_start_date date,
ADD COLUMN registration_start_time time with time zone,
ADD COLUMN registration_end_date date,
ADD COLUMN registration_end_time time with time zone;


/* *********** need to update in entity
 * Rename type_id to program_type_id
 */
ALTER TABLE public.program_v1
RENAME COLUMN type_id TO program_type_id;

ALTER TABLE public.program_v1
ALTER COLUMN program_type_id SET NOT NULL;

ALTER TABLE public.program_v1
ADD COLUMN start_date date,
ADD COLUMN start_time time with time zone,
ADD COLUMN end_date date,
ADD COLUMN end_time time with time zone,
ADD COLUMN registration_start_date date,
ADD COLUMN registration_start_time time with time zone,
ADD COLUMN registration_end_date date,
ADD COLUMN registration_end_time time with time zone;

ALTER TABLE public.users
ALTER COLUMN is_infiminute SET DEFAULT true;

ALTER TABLE public.users
ALTER COLUMN is_infipath SET DEFAULT true;

ALTER TABLE public.users
ALTER COLUMN is_infiminute_user_active SET DEFAULT true;

ALTER TABLE public.users
ALTER COLUMN country_code TYPE character varying(7);

ALTER TABLE public.users
ALTER COLUMN status_updated_at TYPE timestamp without time zone;

ALTER TABLE public.webinar_registration
ALTER COLUMN created_at TYPE timestamp with time zone;

ALTER TABLE public.webinar_registration
ALTER COLUMN updated_at TYPE timestamp with time zone;

ALTER TABLE public.webinar_registration
ALTER COLUMN deleted_at TYPE timestamp with time zone;

ALTER TABLE public.webinar
ALTER COLUMN deleted_at TYPE timestamp with time zone;

ALTER TABLE public.webinar_analytics
ADD COLUMN country_code character varying(255);


CREATE SEQUENCE hdb_program_registration_rm_rating_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

ALTER TABLE hdb_program_registration_rm_rating_type
    ALTER COLUMN id SET DEFAULT nextval('hdb_program_registration_rm_rating_type_id_seq');

ALTER SEQUENCE public.hdb_program_registration_rm_rating_type_id_seq OWNED BY public.hdb_program_registration_rm_rating_type.id;

