UPDATE program_type_v1
SET 
  name = 'Entrainment',
  description = 'A residential spiritual retreat with Mahatria',
  mode_of_operation = 'offline',
  frequency = 'yearly',
  max_session_duration_days = 4,
  has_multiple_sessions = false,
  default_start_time = '20:00:00',
  default_end_time = '21:00:00',
  default_duration = '60',
  requires_residence = true,
  involves_travel = true,
  has_checkin_checkout = true,
  requires_payment = true,
  requires_attendance_all_sessions = true,
  allows_minors = true,
  allows_proxy_registration = true,
  requires_approval = false,
  registration_level = 'program',
  is_active = true,
  waitlist_applicable = true,
  max_capacity = 1200,
  limited_seats = true,
  is_grouped_program = false,
  logo_url = 'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/logo/entrainment-logo.svg',
  banner_url = 'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/Entrainment.png',
  key = 'PT_ENTRAINMENT',
  igst = 18.00,
  cgst = 9.00,
  sgst = 9.00,
  gst_percentage = 18.00,
  tds_percent = 10.00,
  gst_number = '36AACCI7694H1Z5',
  tds_applicability = 'base_only',
  invoice_sender_name = 'infinitheism spiritual foundation private limited',
  invoice_sender_pan = 'AACCI7694H',
  invoice_sender_cin = 'U74900TN2011PTC083263',
  venue = 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
  is_special_program = true
WHERE id = 8;


INSERT INTO program_v1 (
   program, type_id, name, description, mode_of_operation, online_type,
  max_session_duration_days, has_multiple_sessions, frequency,
  default_start_time, default_end_time, duration, requires_residence,
  involves_travel, has_checkin_checkout, requires_payment,
  requires_attendance_all_sessions, allows_minors, allows_proxy_registration,
  requires_approval, registration_level, waitlist_applicable, limited_seats,
  is_grouped_program, no_of_session, max_capacity, total_seats,
  waitlist_trigger_count, available_seats, filled_seats, program_fee,
  base_price, gst_percentage, currency, venue, status, is_active, code,
  banner_image_url, meta, created_at, updated_at, deleted_at, created_by,
  updated_by, is_approval_required, is_residence_required, is_travel_involved,
  group_id, is_primary_program, primary_program_id, group_display_order,
  cgst, sgst, igst, tan_percent, registration_starts_at, registration_ends_at,
  checkin_at, checkout_at, starts_at, ends_at, tds_percent, gst_number,
  tds_applicability, invoice_sender_name, invoice_sender_pan,
  invoice_sender_cin, venue_address_id, invoice_sender_address,
  helpline_number, email_sender_name, venue_name_in_emails, launch_date,
  logo_url, checkin_ends_at, checkout_ends_at
)
VALUES (
   'PT_ENTRAINMENT', 8, 'Entrainment25',
  'A residential spiritual retreat with Mahatria', 'offline', 'NA',
  4, false, 'yearly', '09:00:00', '18:00:00', '4 days', true, true, true,
  true, true, true, true, false, 'program', true, true, false, 0, 0, 1200,
  10, 1200, 0, 49999.00, 49999.00, 18.00, 'INR',
  'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
  'published', true, 'EN25',
  'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/Entrainment.png',
  '{}',
  '2025-07-18T06:49:24.72639+00:00', '2025-07-18T06:52:29.614942+00:00', NULL,
  8319, 8319, false, false, false, NULL, NULL, NULL, NULL,
  9.00, 9.00, 18.00, 0.00,
  '2024-01-01T00:00:00+00:00', '2024-01-14T23:59:59+00:00',
  '2025-09-04T16:00:00+00:00', '2025-09-07T14:00:00+00:00',
  '2025-09-04T16:00:00+00:00', '2025-09-07T14:00:00+00:00',
  10.00, '36AACCI7694H1Z5', 'base_only',
  'infinitheism spiritual foundation private limited', 'AACCI7694H',
  'U74900TN2011PTC083263', 91,
  'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
  '+91-9841660000', 'events@infinitheism.com',
  'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
  '2025-07-18T06:35:26.67+00:00',
  'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/logo/entrainment-logo.svg',
  '2025-09-04T21:00:00+00:00', '2025-09-07T23:59:59+00:00'
);

-- need to get the program_id from the above insert
-- and use it in the program_session insert below
-- Assuming the program_id is 824 based on the provided context
-- If the program_id is different, replace 824 with the actual program_id

INSERT INTO program_session (
   program_id, name, description, mode_of_operation, online_type,
  max_session_duration_days, has_multiple_sessions, frequency,
  default_start_time, default_end_time, duration, requires_residence,
  involves_travel, has_checkin_checkout, requires_payment,
  requires_attendance_all_sessions, allows_minors, allows_proxy_registration,
  requires_approval, registration_level, waitlist_applicable, limited_seats,
  is_grouped_program, total_seats, waitlist_trigger_count, available_seats,
  reserved_seats, filled_seats, max_capacity, session_fee, base_price,
  gst_percentage, currency, venue, status, is_active, code, display_order,
  banner_image_url, meeting_link, meeting_id, meeting_password, meta,
  created_at, updated_at, deleted_at, created_by, updated_by,
  is_residence_required, is_travel_required, cgst, sgst, igst, tan_percent,
  registration_starts_at, registration_ends_at, checkin_at, checkout_at,
  starts_at, ends_at, tds_percent, gst_number, tds_applicability,
  invoice_sender_name, invoice_sender_pan, invoice_sender_cin,
  venue_address_id, invoice_sender_address, helpline_number,
  email_sender_name, venue_name_in_emails, launch_date, logo_url,
  checkin_ends_at, checkout_ends_at
)
VALUES (
  824, 'Entrainment25',
  'A residential spiritual retreat with Mahatria', 'offline', 'NA',
  8, true, 'yearly', NULL, NULL, NULL, false, false, false,
  true, true, false, false, false, 'session', false, true,
  false, 1200, 10, 1200, 0, 0, NULL, NULL, 49999.00, 18.00,
  'INR',
  'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
  'scheduled', true, 'EN25', 1,
  'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/Entrainment.png',
  NULL, NULL, NULL, '{}',
  '2025-07-18T07:33:32.34267+00:00', '2025-07-18T07:33:32.34267+00:00', NULL,
  8319, 8319, false, false, 9.00, 9.00, 18.00, 0.00,
  '2024-01-01T00:00:00+00:00', '2024-01-14T23:59:59+00:00',
  '2025-09-04T16:00:00+00:00', '2025-09-07T12:00:00+00:00',
  '2025-09-04T16:00:00+00:00', '2025-09-07T14:00:00+00:00',
  10.00, '36AACCI7694H1Z5', 'base_only',
  'infinitheism spiritual foundation private limited', 'AACCI7694H',
  'U74900TN2011PTC083263', NULL,
  'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
  '+91-9841660000', 'events@infinitheism.com',
  'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
  '2025-07-18T06:35:26.67+00:00',
  'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/logo/entrainment-logo.svg',
  '2025-09-04T21:00:00+00:00', '2025-09-07T14:00:00+00:00'
);
