CREATE TABLE hdb_registration_approval_track (
    id BIGSERIAL PRIMARY KEY,
    approval_id BIGINT NOT NULL REFERENCES hdb_registration_approval(id),
    registration_id BIGINT NOT NULL REFERENCES hdb_program_registration(id),
    approval_status approval_status_enum NOT NULL DEFAULT 'pending',
    approval_date TIMESTAMPTZ NULL,
    approved_by BIGINT NULL REFERENCES users(id),
    rejection_reason TEXT NULL,
    reviewer_comments TEXT NULL,
    auto_approved BOOLEAN NOT NULL DEFAULT FALSE,
    created_at TIMESTAMPTZ DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMPTZ DEFAULT CURRENT_TIMESTAMP,
    created_by BIGINT NULL REFERENCES users(id) ON DELETE SET NULL,
    updated_by BIGINT NULL REFERENCES users(id) ON DELETE SET NULL
);


  ALTER TABLE hdb_registration_approval_track
    ADD COLUMN type VARCHAR(255) DEFAULT 'registration',
    ADD COLUMN swap_request_id BIGINT;