import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { UserRegistrationMapController } from './user-registration-map.controller';
import { UserRegistrationMapService } from './user-registration-map.service';
import { UserRegistrationMapRepository } from './user-registration-map.repository';
import {
  ProgramRegistration,
  User,
  UserParticipationSummary,
  UserRegistrationMap,
} from 'src/common/entities';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';

@Module({
  imports: [
    TypeOrmModule.forFeature([
      UserRegistrationMap,
      User,
      ProgramRegistration,
      UserParticipationSummary,
    ]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
  ],
  controllers: [UserRegistrationMapController],
  providers: [
    UserRegistrationMapService,
    UserRegistrationMapRepository,
    CommonDataService,
    AppLoggerService,
  ],
  exports: [UserRegistrationMapService, UserRegistrationMapRepository],
})
export class UserRegistrationMapModule {}
