import { ApiProperty } from '@nestjs/swagger';
import { Type } from 'class-transformer';
import {
  ArrayNotEmpty,
  ArrayUnique,
  IsArray,
  IsInt,
  IsOptional,
  IsPositive,
} from 'class-validator';

export class CreateUserRegistrationMapDto {
  @ApiProperty({ description: 'Seeker identifier', example: 101 })
  @Type(() => Number)
  @IsInt()
  @IsPositive()
  userId: number;

  @ApiProperty({
    description: 'Completed registration identifiers to associate with the user',
    type: [Number],
    example: [201, 202],
  })
  @IsArray()
  @ArrayNotEmpty()
  @ArrayUnique()
  @Type(() => Number)
  @IsInt({ each: true })
  @IsPositive({ each: true })
  registrationIds: number[];

  @ApiProperty({ description: 'User who creates the mapping', example: 1, required: false })
  @IsOptional()
  @Type(() => Number)
  @IsInt()
  @IsPositive()
  createdBy?: number;

  @ApiProperty({ description: 'User who updates the mapping', example: 1, required: false })
  @IsOptional()
  @Type(() => Number)
  @IsInt()
  @IsPositive()
  updatedBy?: number;
}
