import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { UserProfileExtension } from 'src/common/entities/user-profile-extension.entity';
import { User } from 'src/common/entities/user.entity';
import { UserProfileExtensionController } from './user-profile-extension.controller';
import { UserProfileExtensionService } from './user-profile-extension.service';
import { UserProfileExtensionRepository } from './user-profile-extension.repository';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([UserProfileExtension, User]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
  ],
  controllers: [UserProfileExtensionController],
  providers: [
    UserProfileExtensionService,
    UserProfileExtensionRepository,
    CommonDataService,
  ],
  exports: [UserProfileExtensionService, UserProfileExtensionRepository],
})
export class UserProfileExtensionModule {}
