import { ApiProperty } from '@nestjs/swagger';

export class AssociationQuestionOptionDto {
  @ApiProperty({ description: 'Option key/value' })
  key: string;

  @ApiProperty({ description: 'Option display label' })
  label: string;
}

export class AssociationQuestionDto {
  @ApiProperty({ description: 'Question label/text to display' })
  label: string;

  @ApiProperty({ description: 'Question identifier/key' })
  key: string;

  @ApiProperty({ description: 'Question type (e.g., text, radio, select)' })
  type: string;

  @ApiProperty({ description: 'Available options for the question', type: [String] })
  options?: string[];

  @ApiProperty({ description: 'Current answer/selected option' })
  answer: string;

  @ApiProperty({ description: 'Total count' })
  totalCount?: number;

  @ApiProperty({ description: 'Display order for sorting questions' })
  order: number;

  @ApiProperty({ description: 'Additional metadata', required: false })
  metadata?: any;
}

export class AssociationProgramDto {
  @ApiProperty({ description: 'Program ID' })
  programId: number;

  @ApiProperty({ description: 'Program name' })
  programName: string;

  @ApiProperty({ description: 'Program type key (PT_TAT, PT_ENTRAINMENT, PT_HDBMSD)' })
  programTypeKey: string;

  @ApiProperty({ description: 'Program year' })
  programYear: number;

  @ApiProperty({ description: 'Program description' })
  description: string;

  @ApiProperty({ description: 'Questions for this program', type: [AssociationQuestionDto] })
  questions: AssociationQuestionDto[];
}

export class ProgramParticipationDto {
  @ApiProperty({ description: 'Program ID' })
  programId: number;

  @ApiProperty({ description: 'Program name' })
  programName: string;

  @ApiProperty({ description: 'Sub program ID', required: false })
  subProgramId?: number;

  @ApiProperty({ description: 'Sub program name', required: false })
  subProgramName?: string;

  @ApiProperty({ description: 'Sub program type', required: false })
  subProgramType?: string;

  @ApiProperty({ description: 'Session ID', required: false })
  sessionId?: number;

  @ApiProperty({ description: 'Session name', required: false })
  sessionName?: string;

  @ApiProperty({ description: 'Program start date' })
  programStartsAt: Date;

  @ApiProperty({ description: 'Program end date' })
  programEndsAt: Date;

  @ApiProperty({ description: 'Year of participation' })
  year: number;
}

export class SubProgramTypeWiseParticipationDto {
  @ApiProperty({ description: 'Sub program type' })
  subProgramType: string;

  @ApiProperty({ description: 'Number of programs participated of this type' })
  count: number;
}

export class YearWiseParticipationDto {
  @ApiProperty({ description: 'Year' })
  year: number;

  @ApiProperty({ description: 'Number of programs participated in this year' })
  programsCount: number;

  @ApiProperty({ description: 'List of programs in this year', type: [ProgramParticipationDto] })
  programs: ProgramParticipationDto[];
}

export class UserProgramExperienceDto {
  @ApiProperty({ description: 'Program experience record identifier' })
  id: number;

  @ApiProperty({ description: 'Associated registration identifier', required: false, nullable: true })
  registrationId: number | null;

  @ApiProperty({ description: 'Lookup data identifier', required: false, nullable: true })
  lookupDataId: number | null;

  @ApiProperty({ description: 'Lookup key', required: false })
  lookupKey?: string;

  @ApiProperty({ description: 'Lookup label', required: false })
  lookupLabel?: string;

  @ApiProperty({ description: 'Lookup category', required: false })
  lookupCategory?: string;
}

export class UserParticipationSummaryDto {
  @ApiProperty({ description: 'User ID' })
  userId: number;

  @ApiProperty({ description: 'User full name' })
  userFullName: string;

  @ApiProperty({ description: 'User email' })
  userEmail: string;

  @ApiProperty({ description: 'Experiences from profile extension', required: false })
  whichOfTheFollowingHaveYouExperienced?: string;

  @ApiProperty({ description: 'Contact person from profile extension', required: false })
  contactPerson?: string;

  @ApiProperty({ description: 'When was last HDB/MSD from profile extension', required: false })
  whenWasYourLastHdbMsd?: string;

  @ApiProperty({ description: 'How many HDB/MSD done from profile extension', required: false })
  howManyHdbMsdHaveYouDone?: number;

  @ApiProperty({ description: 'Total number of programs attended' })
  totalProgramsAttended: number;

  @ApiProperty({ description: 'First participation date', required: false })
  firstParticipationDate: Date | null;

  @ApiProperty({ description: 'Latest participation date', required: false })
  latestParticipationDate: Date | null;

  @ApiProperty({ description: 'Number of years participated' })
  totalYearsParticipated: number;

  @ApiProperty({ description: 'Year wise participation breakdown', type: [YearWiseParticipationDto] })
  yearWiseParticipation: YearWiseParticipationDto[];

  @ApiProperty({ description: 'Sub program type wise participation breakdown', type: [SubProgramTypeWiseParticipationDto] })
  subProgramTypeWiseParticipation: SubProgramTypeWiseParticipationDto[];

  @ApiProperty({ description: 'All programs participated', type: [ProgramParticipationDto] })
  allPrograms: ProgramParticipationDto[];

  @ApiProperty({ description: 'List of unique program names' })
  uniqueProgramNames: string[];

  @ApiProperty({ description: 'Association period in years' })
  associationYears: number;

  @ApiProperty({ description: 'Association questions and answers', type: [AssociationQuestionDto] })
  associationQuestions: AssociationQuestionDto[];

  @ApiProperty({ description: 'List of program experiences recorded for the user', type: [UserProgramExperienceDto] })
  userProgramExperiences: UserProgramExperienceDto[];
}
