import { forwardRef, Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { ProgramRegistration, SeekerProgramExperience, User } from 'src/common/entities';
import { ResponseService } from 'src/common/response-handling/response-handler';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { UserModule } from 'src/user/user.module';
import { AuthModule } from 'src/auth/auth.module';
import { SeekerProgramExperienceRepository } from './seeker-program-experience.repository';
import { SeekerProgramExperienceController } from './seeker-program-experience.controller';
import { SeekerProgramExperienceService } from './seeker-program-experience.service';

@Module({
  imports: [
    TypeOrmModule.forFeature([SeekerProgramExperience , ProgramRegistration, User]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
  ],
  controllers: [SeekerProgramExperienceController],
  providers: [
    SeekerProgramExperienceService,
    SeekerProgramExperienceRepository,
    ResponseService,
    AppLoggerService,
    CommonDataService,
  ],
  exports: [SeekerProgramExperienceService],
})
export class SeekerProgramExperienceModule {}