import { Controller } from '@nestjs/common';
import { SchedulerService } from './scheduler.service';
import { Cron } from '@nestjs/schedule';
import { AppLoggerService } from 'src/common/services/logger.service';
import { CRON_CONSTANTS } from 'src/common/constants/constants';

@Controller('scheduler')
export class SchedulerController {
  constructor(
    private readonly schedulerService: SchedulerService,
    private readonly logger: AppLoggerService,
  ) {}

  @Cron('0 0 * * *') // Triggers every day at 12:00 AM
  async handlePaymentRemindersTask() {
    try {
      await this.schedulerService.sendPaymentReminders();
    } catch (error) {
      console.error('Error occurred while sending payment reminders:', error);
    }
  }

  /**
   * Scheduled job to update signed URLs for registrations
   * Cron expression is configurable via SIGNED_URLS_SCHEDULED_CRON environment variable
   * Default: '0 23 * * 0' (runs every Sunday at 11:00 PM)
   */
  // this.configService.get<string>('SIGNED_URLS_SCHEDULED_JOB_ENABLED', 'false') === 'true';
  @Cron(CRON_CONSTANTS.SIGNED_URLS_SCHEDULED_CRON || '0 23 * * 0')
  async handleSignedUrlsUpdateTask() {
    try {
      this.logger.log(`Starting signed URLs update scheduled task, ${CRON_CONSTANTS.SIGNED_URLS_SCHEDULED_CRON}`);
      const result = await this.schedulerService.updateSignedUrlsScheduled();
      this.logger.log('Signed URLs update scheduled task completed:', result);
    } catch (error) {
      this.logger.error('Error occurred while updating signed URLs:', error);
    }
  }
}
