
export interface SchedulerLogFilters {
  jobName?: string;
  jobType?: string;
  executionStatus?: 'pending' | 'success' | 'failed' | 'in_progress';
  triggeredType?: 'manual' | 'scheduled' | 'automatic';
  programId?: number;
  registrationId?: number;
  triggeredByUserId?: number;
  startDate?: Date;
  endDate?: Date;
}

export interface SchedulerLogStatistics {
  totalJobs: number;
  successfulJobs: number;
  failedJobs: number;
  pendingJobs: number;
  averageExecutionTime: number;
  byJobType: Record<string, number>;
  byStatus: Record<string, number>;
}