import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { ProgramRoomInventoryMapService } from './program-room-inventory-map.service';
import { RoomInventoryRepository } from './room-inventory.repository';
import { ProgramRoomInventoryMapRepository } from './program-room-inventory-map.repository';
import { RoomInventoryService } from './room-inventory.service';
import { RoomInventoryController } from './room-inventory.controller';
import { ProgramRoomInventoryMap } from '../common/entities/program-room-inventory-map.entity';
import { ResponseService } from '../common/response-handling/response-handler';
import ErrorHandler from '../common/response-handling/error-handling';
import { AppLoggerService } from '../common/services/logger.service';
import { AuthModule } from '../auth/auth.module';
import { UserModule } from '../user/user.module';
import { ProgramRegistrationModule } from '../program-registration/program-registration.module';
import { LookupDataModule } from '../lookup-data/lookup-data.module';

/**
 * Module for managing room inventory operations
 * Provides services, repositories, and controllers for room inventory management
 * Includes comprehensive room listing, KPI calculations, and filtering capabilities
 */
@Module({
  imports: [
    TypeOrmModule.forFeature([ProgramRoomInventoryMap]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
    forwardRef(() => ProgramRegistrationModule),
    LookupDataModule,
  ],
  controllers: [
    RoomInventoryController,
  ],
  providers: [
    ProgramRoomInventoryMapService,
    RoomInventoryRepository,
    ProgramRoomInventoryMapRepository,
    RoomInventoryService,
    ResponseService,
    ErrorHandler,
    AppLoggerService,
  ],
  exports: [
    ProgramRoomInventoryMapService,
    RoomInventoryRepository,
    ProgramRoomInventoryMapRepository,
    RoomInventoryService,
  ],
})
export class RoomInventoryModule {}