import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { RoomAllocationService } from './room-allocation.service';
import { RoomAllocationController } from './room-allocation.controller';
import { RoomAllocationRepository } from './room-allocation.repository';
import { RoomAllocation } from 'src/common/entities/room-allocation.entity';
import { Program } from 'src/common/entities/program.entity';
import { ProgramRegistration } from 'src/common/entities/program-registration.entity';
import { ProgramRoomInventoryMap } from 'src/common/entities/program-room-inventory-map.entity';
import { AppLoggerService } from 'src/common/services/logger.service';
import { CommonDataService } from 'src/common/services/commonData.service';
import { ResponseService } from 'src/common/response-handling/response-handler';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { RoomInventoryModule } from 'src/room-inventory/room-inventory.module';
import { ProgramRegistrationModule } from 'src/program-registration/program-registration.module';
import { LookupDataModule } from 'src/lookup-data/lookup-data.module';

/**
 * Room Allocation Module
 * Manages room allocation functionality with complete CRUD operations
 * Handles room assignment to program registrations with bed positions and remarks
 */
@Module({
  imports: [
    TypeOrmModule.forFeature([RoomAllocation, Program, ProgramRegistration, ProgramRoomInventoryMap]),
    AuthModule,
    UserModule,
    RoomInventoryModule,
    ProgramRegistrationModule,
    LookupDataModule,
  ],
  controllers: [RoomAllocationController],
  providers: [
    RoomAllocationService,
    RoomAllocationRepository,
    AppLoggerService,
    CommonDataService,
    ResponseService,
  ],
  exports: [
    RoomAllocationService,
    RoomAllocationRepository,
  ],
})
export class RoomAllocationModule {}