import { ApiProperty } from '@nestjs/swagger';
import { IsInt, IsOptional, IsString, Max, Min, IsNotEmpty } from 'class-validator';

/**
 * Data Transfer Object for transferring room allocation
 * Used for updating bed position within same room or transferring to a different room
 */
export class TransferRoomAllocationDto {
  @ApiProperty({ 
    description: 'Program ID - the allocation must belong to this program',
    example: 123,
    type: 'integer',
    required: true
  })
  @IsInt()
  @IsNotEmpty()
  @Min(1)
  programId: number;

  @ApiProperty({ 
    description: 'New program room inventory map ID (optional - if null, only updates bed position in current room)',
    example: 2,
    type: 'integer',
    required: false,
    nullable: true
  })
  @IsOptional()
  @IsInt()
  newInventoryId?: number | null;

  @ApiProperty({ 
    description: 'New bed position within the room',
    example: 3,
    type: 'integer',
    minimum: 1,
    maximum: 10,
    required: true
  })
  @IsInt()
  @Min(1)
  @Max(10)
  bedPosition: number;

  @ApiProperty({ 
    description: 'Sub-program ID (optional) - if provided, validates that the allocation belongs to this sub-program',
    example: 10,
    type: 'integer',
    required: false
  })
  @IsOptional()
  @IsInt()
  @Min(1)
  subProgramId?: number;

  @ApiProperty({ 
    description: 'Additional remarks for the room allocation transfer',
    example: 'Transferred to preferred room due to medical requirements',
    type: 'string',
    required: false
  })
  @IsOptional()
  @IsString()
  remarks?: string;
}