import { ApiProperty } from '@nestjs/swagger';
import { IsInt, IsOptional } from 'class-validator';

export class UpdateSignedUrlsDto {
  @ApiProperty({
    description: 'Program ID for which to update signed URLs',
    example: 1,
    required: true,
  })
  @IsInt()
  programId: number;

  @ApiProperty({
    description: 'Optional registration ID. If provided, updates only this registration. If not provided, updates all registrations of the program.',
    example: 123,
    required: false,
  })
  @IsOptional()
  @IsInt()
  registrationId?: number;
}
