import { ApiProperty } from '@nestjs/swagger';
import { IsEnum, IsInt, IsOptional, IsString, IsDateString } from 'class-validator';
import { TravelTypeEnum } from 'src/common/enum/travel-type.enum';
import { TravelStatusEnum } from 'src/common/enum/travel-status.enum';

export class CreateRegistrationTravelPlanDto {
  @ApiProperty()
  @IsInt()
  registrationId: number;

  @ApiProperty({ enum: TravelTypeEnum })
  @IsEnum(TravelTypeEnum)
  travelType: TravelTypeEnum;


  @ApiProperty({ enum: TravelTypeEnum, required: false })
  @IsOptional()
  @IsEnum(TravelTypeEnum)
  returnTravelType?: TravelTypeEnum;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  airlineName?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  flightNumber?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsDateString()
  arrivalDatetime?: Date;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  departureLocation?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  pickupTime?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  pickupLocation?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  checkinAt?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  checkinLocation?: string;

  @ApiProperty({ enum: TravelStatusEnum, required: false })
  @IsOptional()
  @IsEnum(TravelStatusEnum)
  travelPlanStatus?: TravelStatusEnum;

  @ApiProperty()
  @IsInt()
  createdBy: number;

  @ApiProperty()
  @IsInt()
  updatedBy: number;
}
