import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { RegistrationPaymentDetail } from 'src/common/entities';
import { RegistrationPaymentDetailService } from './registration-payment-detail.service';
import { RegistrationPaymentDetailController } from './registration-payment-detail.controller';
import { RegistrationPaymentDetailRepository } from './registration-payment-detail.repository';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';

@Module({
  imports: [TypeOrmModule.forFeature([RegistrationPaymentDetail]), forwardRef(() => AuthModule), forwardRef(() => UserModule)],
  controllers: [RegistrationPaymentDetailController],
  providers: [RegistrationPaymentDetailService, RegistrationPaymentDetailRepository, CommonDataService, AppLoggerService],
  exports: [RegistrationPaymentDetailService, RegistrationPaymentDetailRepository],
})
export class RegistrationPaymentDetailModule {}
