import { ApiProperty } from '@nestjs/swagger';
import { IsBoolean, IsDateString, IsEnum, IsInt, IsNumber, IsOptional, IsString } from 'class-validator';
import { InvoiceTypeEnum } from 'src/common/enum/invoice-type.enum';
import { InvoiceStatusEnum } from 'src/common/enum/invoice-status.enum';

export class CreateRegistrationInvoiceDetailDto {
  @ApiProperty()
  @IsInt()
  registrationId: number;

  @ApiProperty({ enum: InvoiceTypeEnum })
  @IsEnum(InvoiceTypeEnum)
  invoiceType: InvoiceTypeEnum;

  @ApiProperty()
  @IsString()
  invoiceName: string;

  @ApiProperty()
  @IsString()
  invoiceEmail: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  panNumber?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsBoolean()
  isGstRegistered?: boolean;

  @ApiProperty()
  @IsString()
  invoiceAddress: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsNumber()
  taxAmount?: number;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  invoiceSequenceNumber?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  razorpayId?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsDateString()
  invoiceIssuedDate?: Date;

  @ApiProperty({ enum: InvoiceStatusEnum, required: false })
  @IsOptional()
  @IsEnum(InvoiceStatusEnum)
  invoiceStatus?: InvoiceStatusEnum;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsBoolean()
  tdsApplicable?: boolean;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  tanNumber?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsDateString()
  handoverDate?: Date;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  handoverTo?: string;

  @ApiProperty()
  @IsInt()
  createdBy: number;

  @ApiProperty()
  @IsInt()
  updatedBy: number;
}
