import { forwardRef, Module } from '@nestjs/common';
import { RegistrationGroupingService } from './registration-grouping.service';
import { RegistrationGroupingController } from './registration-grouping.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import {
  Program,
  ProgramRegistration,
  RegistrationGroup,
  RegistrationGroupMap,
  RegistrationPair,
  RegistrationPairMap,
} from 'src/common/entities';
import { RegistrationGroupingRepository } from './registration-grouping.repository';
import { AuthService } from 'src/auth/auth.service';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { LookupDataModule } from 'src/lookup-data/lookup-data.module';
import { ProgramModule } from 'src/program/program.module';
import { ResponseService } from 'src/common/response-handling/response-handler';

@Module({
  imports: [
    TypeOrmModule.forFeature([
      RegistrationPair,
      RegistrationPairMap,
      RegistrationGroup,
      RegistrationGroupMap,
      ProgramRegistration,
      Program,
    ]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
    forwardRef(() => LookupDataModule),
    forwardRef(() => ProgramModule),
  ],
  controllers: [RegistrationGroupingController],
  providers: [RegistrationGroupingService, RegistrationGroupingRepository, ResponseService],
})
export class RegistrationGroupingModule {}
