import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Question } from 'src/common/entities/question.entity';
import { QuestionService } from './question.service';
import { QuestionController } from './question.controller';
import { FormSection, QuestionOptionMap, User } from 'src/common/entities';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { QuestionRepository } from './question.repository';
import { CommonDataService } from 'src/common/services/commonData.service';

@Module({
  imports: [TypeOrmModule.forFeature([Question,User,QuestionOptionMap, FormSection]), forwardRef(() => AuthModule), forwardRef(() => UserModule)],
  controllers: [QuestionController],
  providers: [QuestionService,QuestionRepository,CommonDataService],
  exports: [QuestionService, QuestionRepository],
})
export class QuestionModule {}