import { IsString, IsOptional, IsInt, IsObject, IsEnum } from 'class-validator';
import { ApiProperty } from '@nestjs/swagger';
import { CommonStatus } from 'src/common/enum/common-status.enum';

export class CreateQuestionDto {
  @ApiProperty()
  @IsString({ message: 'The label must be a valid string.' })
  label: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsObject({ message: 'The config must be a valid JSON object if provided.' })
  config: Record<string, any>;


  @ApiProperty({ required: false, enum: CommonStatus  })
  @IsOptional()
  @IsEnum(CommonStatus, { message: 'The status must be a valid common status.' })
  status: string;


  @ApiProperty()
  @IsString({ message: 'The type must be a valid string.' })
  type: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsInt({ message: 'The formSectionId must be a valid integer.' })
  formSectionId?: number | null = null;

  @ApiProperty()
  @IsInt({ message: 'The createdBy field must be a valid integer.' })
  createdBy: number;

  @ApiProperty()
  @IsInt({ message: 'The updatedBy field must be a valid integer.' })
  updatedBy: number;
}