import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { QuestionOptionMap, Question, Option, User } from 'src/common/entities';
import { QuestionOptionService } from './question-option.service';
import { QuestionOptionController } from './question-option.controller';
import { UserModule } from 'src/user/user.module';
import { AuthModule } from 'src/auth/auth.module';
import { QuestionOptionRepository } from './question-option.repository';

@Module({
  imports: [TypeOrmModule.forFeature([QuestionOptionMap, Question, Option, User]), forwardRef(() => UserModule), forwardRef(() => AuthModule)],
  controllers: [QuestionOptionController],
  providers: [QuestionOptionService, QuestionOptionRepository],
  exports: [QuestionOptionService, QuestionOptionRepository],
})
export class QuestionOptionModule {}