import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';
import { IsBoolean, IsInt, IsNotEmpty, IsOptional } from 'class-validator';
import { CreateProgramRegistrationDto } from './create-program-registration.dto';

export class UpdateProgramRegistrationDto extends PartialType(
  OmitType(CreateProgramRegistrationDto, ['createdBy', 'updatedBy'] as const),
) {
  @ApiProperty()
  @IsInt()
  @IsNotEmpty()
  updatedBy: number;
}
