import { ApiProperty } from '@nestjs/swagger';
import { IsArray, IsInt, IsOptional } from 'class-validator';
import { Type } from 'class-transformer';

export class DeleteProgramQuestionDto {
  @ApiProperty({ description: 'Program ID' })
  @IsInt()
  programId: number;

  @ApiProperty({ description: 'Program Session ID', required: false })
  @IsOptional()
  @IsInt()
  programSessionId?: number;

  @ApiProperty({ 
    description: 'Array of Section IDs to delete entirely (will delete section and all its questions)',
    type: [Number],
    required: false 
  })
  @IsOptional()
  @IsArray()
  @Type(() => Number)
  @IsInt({ each: true })
  sections?: number[];

  @ApiProperty({ 
    description: 'Array of Question IDs to delete individually',
    type: [Number],
    required: false 
  })
  @IsOptional()
  @IsArray()
  @Type(() => Number)
  @IsInt({ each: true })
  questionIds?: number[];
}