import { forwardRef, Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import {
  Preference,
  Program,
  ProgramRegistration,
  ProgramSession,
  User,
} from 'src/common/entities';
import { PreferenceService } from './preference.service';
import { PreferenceController } from './preference.controller';
import { PreferenceRepository } from './preference.repository';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { CommonDataService } from 'src/common/services/commonData.service';

@Module({
  imports: [
    TypeOrmModule.forFeature([
      Preference,
      ProgramRegistration,
      ProgramSession,
      Program,
      User,
    ]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
  ],
  controllers: [PreferenceController],
  providers: [PreferenceService, PreferenceRepository, CommonDataService],
  exports: [PreferenceService, PreferenceRepository],
})
export class PreferenceModule {}
